ORCA/M Asm65816 2.1.0

0001 D400              ;==========================================================
0002 D400              ;
0003 D400              ;  file init.2
0004 D400              ;
0005 D400              ;  Contains the main dispatcher, core routines and the
0006 D400              ;  graphics user interface portions of the init package,
0007 D400              ;  or at least as much of them as will fit in 3k.
0008 D400              ;
0009 D400              ;  Author:      Andy Stadler
0010 D400              ;  Created:     29-Jan-88
0011 D400              ;  Modified:    See modification history below
0012 D400              ;
0013 D400              ;  Copyright (C) 1988-1989 Apple Computer, Inc.
0014 D400              ;  All Rights Reserved.
0015 D400              ;
0016 D400              ;==========================================================
0017 D400
0018 D400
0019 D400              ;==========================================================
0020 D400              ;
0021 D400              ;  file init.main
0022 D400              ;
0023 D400              ;  Actually handles dispatching the $24 and $25 calls.
0024 D400              ;
0025 D400              ;  Author:      Andy Stadler
0026 D400              ;  Created:     1-Jan-88
0027 D400              ;  Modified:    See modification history below
0028 D400              ;
0029 D400              ;  Copyright (C) 1987 Apple Computer, Inc.
0030 D400              ;  All Rights Reserved.
0031 D400              ;
0032 D400              ;==========================================================
0033 D400              ;
0034 D400              ;  Modification history:
0035 D400              ;
0036 D400              ;  01-Feb-88    ADS     Initial release
0037 D400              ;  23-Feb-88    ADS     Setting my own data bank
0038 D400              ;                       Using that for data area references
0039 D400              ;  06-Apr-88    CAE     Modified to handle new field in class 1 calls
0040 D400              ;  21-Dec-88    CAE     Added line in init_main to jsr to display_msg
0041 D400              ;  09-Jan-89    CAE     Added line in init_main to clear msg_flag
0042 D400              ;  09-Mar-89    CAE     Moved jsr setup_screen to init_present to fix bug
0043 D400              ;  26-Jul-89    CAE     Split setup_screen into 2 routines and modified
0044 D400              ;                       init_present to fix bug in which the init_screen
0045 D400              ;                       flag was not initialized in the non-dialog mode
0046 D400              ;                       which caused display_msg to screw up.
0047 D400              ;==========================================================
0048 D400
0049 D400              ;==========================================================
0050 D400              ;
0051 D400              ;  init.grx
0052 D400              ;
0053 D400              ;  Super hires graphics based user interface for the
0054 D400              ;  init package.  Puts up a dialog window and prompts
0055 D400              ;  the user for selection of formatting options.
0056 D400              ;
0057 D400              ;  Author:      Andy Stadler
0058 D400              ;  Created:     11-Jan-88
0059 D400              ;  Modified:    See modification history below
0060 D400              ;
0061 D400              ;  Copyright Apple Computer, Inc. 1987-1989
0062 D400              ;  All rights reserved.
0063 D400              ;
0064 D400              ;==========================================================
0065 D400              ;
0066 D400              ;  Mod history
0067 D400              ;
0068 D400              ;  01-Feb-88    ADS     Initial release
0069 D400              ;  15-Feb-88    ADS     Added entry points for init.tx
0070 D400              ;                       Changed to use international strings
0071 D400              ;  23-Feb-88    ADS     General crunching
0072 D400              ;                       Additions for 'format too large' indicator
0073 D400              ;  30-Mar-88    CAE     Changed to use strings which say
0074 D400              ;                       'Format' or 'Erase' instead of 'Initialize'
0075 D400              ;  06-Apr-88    CAE     Modified to handle new field in class 1 calls
0076 D400              ;
0077 D400              ;==========================================================
0078 D400
0079 D400                       eject 
0080 D400              ;==========================================================
0081 D400              ;
0082 D400              ;  file init.core
0083 D400              ;
0084 D400              ;  Contains the main routines for the init package.
0085 D400              ;  Everything past the entry vectors but not including
0086 D400              ;  user interface.
0087 D400              ;
0088 D400              ;  This is all a part of the bank 1 language card area.
0089 D400              ;
0090 D400              ;  Author:      Andy Stadler
0091 D400              ;  Created:     15-Dec-87
0092 D400              ;  Modified:    See modification history below
0093 D400              ;
0094 D400              ;  Copyright (C) 1987 Apple Computer, Inc.
0095 D400              ;  All Rights Reserved.
0096 D400              ;
0097 D400              ;==========================================================
0098 D400              ;
0099 D400              ;  Modification history:
0100 D400              ;
0101 D400              ;  01-Feb-88    ADS     initial release
0102 D400              ;  04-Feb-88    ADS     hooked to actual text dialog
0103 D400              ;  10-Feb-88    ADS     make_fmt_str will round up drive
0104 D400              ;                       sizes instead of truncating, so a
0105 D400              ;                       19.8 Meg hard disk says 20MB.
0106 D400              ;  23-Feb-88    ADS     General crunching
0107 D400              ;                       Use of abs mode for data area refs
0108 D400              ;                       call_tools_0 added
0109 D400              ;                       Stuff for 'size warning' messages added
0110 D400              ;  06-Apr-88    CAE     modified to handle new field in class 1 Format
0111 D400              ;                       and Erase calls
0112 D400              ;  04-May-88    CAE     Format options now show only current
0113 D400              ;                       block size if Erase call made
0114 D400              ;                       Strings in make_fmt_str routine
0115 D400              ;                       moved to data segment to gain space.
0116 D400              ;  29-Jun-88    CAE     Fixed compare code in cmp_fmt_fst.
0117 D400              ;  21-Jul-88    CAE     Fixed compare code in chk_fst_size.
0118 D400              ;  22-Jul-88    CAE     Fixed setup_screen so that it goes
0119 D400              ;                       into text mode if ListMgr not loaded.
0120 D400              ;  08-Feb-89    CAE     Added check for error after call to 
0121 D400              ;                       tx_dialog in init_present.
0122 D400              ;  23-Mar-89    CAE     Modified make_fmt_str to not round up Megs
0123 D400              ;==========================================================
0124 D400
0125 D400
0126 D400              init_core Proc Export
0127 D400
0128 D400              ;==========================================================
0129 D400              ;
0130 D400              ;  jsl call_alloc       (alloc_seg)
0131 D400              ;  jsl call_deref       (deref)
0132 D400              ;  jsl call_release     (release_seg)
0133 D400              ;  jsl call_dispatch    (dev_dispatcher)
0134 D400              ;
0135 D400              ;  Since this code is in the language card, glue is needed
0136 D400              ;  to get to external routines.
0137 D400              ;
0138 D400              ;  jsr call_tools_0     ($E10000)
0139 D400              ;
0140 D400              ;  Saving 1 byte per call adds up!
0141 D400              ;
0142 D400              ;  Inputs & Outputs:  As per the actual routines.
0143 D400              ;
0144 D400              ;
0145 D400              ; Change History
0146 D400              ;
0147 D400              ; 10 Feb 89     Bryan, Ray and Steve
0148 D400              ;
0149 D400              ; To save a few bytes we share a little code.
0150 D400              ;
0151 D400              ;==========================================================
0152 D400
0153 D400                       EXPORT call_alloc
0154 D400              call_alloc  
0155 D400 F4 01 00              pea   #^alloc_seg
0156 D403 F4 1C FC              pea   |alloc_seg               ;Low word only
0157 D406 80 26                 bra   ShareDispatch
0158 D408
0159 D408                       EXPORT call_deref
0160 D408              call_deref  
0161 D408 F4 01 00              pea   #^deref
0162 D40B F4 38 FC              pea   |deref                   ;Low word only
0163 D40E 80 1E                 bra   ShareDispatch
0164 D410
0165 D410                       EXPORT call_release
0166 D410              call_release  
0167 D410 F4 01 00              pea   #^release_seg
0168 D413 F4 20 FC              pea   |release_seg             ;Low word only
0169 D416 80 16                 bra   ShareDispatch
0170 D418
0171 D418                       EXPORT call_dispatch
0172 D418              call_dispatch  
0173 D418 F4 01 00              pea   #^dev_dispatcher
0174 D41B F4 00 FC              pea   |dev_dispatcher          ;Low word only
0175 D41E 80 0E                 bra   ShareDispatch
0176 D420
0177 D420                       Export call_lock_mem
0178 D420              call_lock_mem  
0179 D420 F4 01 00              pea   #^lock_mem               ; sys service call
0180 D423 F4 68 FC              pea   |lock_mem                ;Low word only
0181 D426 80 06                 bra   ShareDispatch
0182 D428
0183 D428                       Export call_unlock_mem
0184 D428              call_unlock_mem  
0185 D428 F4 01 00              pea   #^unlock_mem             ;sys service call
0186 D42B F4 6C FC              pea   |unlock_mem              ;Low word only
0187 D42E
0188 D42E F4 00 00     ShareDispatch pea   0
0189 D431 22 87 B1 00           jsl   >lc_dispatcher
0190 D435 6B                    rtl   
0191 D436
0192 D436                       entry call_tools_0
0193 D436              call_tools_0  
0194 D436                       with my_direct_page
0195 D436
0196 D436 68                    pla   
0197 D437 85 BA                 sta   <save_rts
0198 D439 22 00 00 E1           jsl   $E10000
0199 D43D D4 BA                 pei   <save_rts
0200 D43F 60                    rts   
0201 D440                       EndP 
0202 D440
0203 D440                       eject 
0204 D440              ;==========================================================
0205 D440              ;
0206 D440              ;  nextmember_1
0207 D440              ;  nextmember_2
0208 D440              ;
0209 D440              ;  This quite common call is centralized here.
0210 D440              ;
0211 D440              ;  Outputs:     A = item number returned from NextMember call
0212 D440              ;               X = trashed
0213 D440              ;               Y = trashed
0214 D440              ;               P = nvmxdizc
0215 D440              ;                   ..000..0
0216 D440              ;
0217 D440              ;==========================================================
0218 D440
0219 D440              nextmember_1 Proc 
0220 D440                       with my_direct_page
0221 D440
0222 D440 A6 C8                 ldx   <list1_handle
0223 D442 A4 CA                 ldy   <list1_handle+2
0224 D444 80 04                 bra   nextmember_com
0225 D446
0226 D446                       Entry nextmember_2
0227 D446              nextmember_2  
0228 D446 A6 CC                 ldx   <list2_handle
0229 D448 A4 CE                 ldy   <list2_handle+2
0230 D44A
0231 D44A              nextmember_com  
0232 D44A A9 00 00              lda   #0
0233 D44D 48                    pha                            ; word result
0234 D44E 48                    pha                            ; NIL = search all entries
0235 D44F 5A                    phy                            ; handle to list control
0236 D450 DA                    phx   
0237 D451 A2 1C 12              ldx   #$121C                   ; NextMember2
0238 D454 20 36 D4              jsr   call_tools_0
0239 D457
0240 D457 68                    pla                            ; result
0241 D458 60                    rts   
0242 D459                       EndP 
0243 D459
0244 D459                       eject 
0245 D459              ;==========================================================
0246 D459              ;
0247 D459              ;  make_fmt_ptr
0248 D459              ;
0249 D459              ;  fmt_list_entry  <-  fmt_list_ptr + (A * fd_size)
0250 D459              ;
0251 D459              ;  Inputs:      fmt_list_ptr = ptr to list of available formats
0252 D459              ;               A = index number of desired entry
0253 D459              ;
0254 D459              ;  Outputs:     fmt_list_entry = ptr to desired entry
0255 D459              ;               A = trashed
0256 D459              ;               X = trashed
0257 D459              ;               Y = trashed
0258 D459              ;               P = nvmxdizc
0259 D459              ;                   ..000...
0260 D459              ;
0261 D459              ;==========================================================
0262 D459
0263 D459              make_fmt_ptr Proc 
0264 D459                       with my_direct_page,fmt_list_record
0265 D459
0266 D459 AA                    tax   
0267 D45A F0 0A                 beq   make_fmt_ptr_2           ; if index == 0 then offset = 0
0268 D45C A9 00 00              lda   #0
0269 D45F
0270 D45F              make_fmt_ptr_1  
0271 D45F 18                    clc   
0272 D460 69 1E 00              adc   #df_size
0273 D463
0274 D463 CA                    dex   
0275 D464 D0 F9                 bne   make_fmt_ptr_1
0276 D466
0277 D466              make_fmt_ptr_2  
0278 D466 18                    clc   
0279 D467 65 84                 adc   <fmt_list_ptr
0280 D469 85 88                 sta   <fmt_list_entry
0281 D46B A9 00 00              lda   #0
0282 D46E 65 86                 adc   <fmt_list_ptr+2
0283 D470 85 8A                 sta   <fmt_list_entry+2
0284 D472
0285 D472 60                    rts   
0286 D473
0287 D473                       export jsl_fmt_ptr
0288 D473 20 59 D4     jsl_fmt_ptr jsr   make_fmt_ptr          ; so I can call from bank 1
0289 D476 6B                    rtl   
0290 D477
0291 D477                       EndP 
0292 D477
0293 D477                       eject 
0294 D477              ;==========================================================
0295 D477              ;
0296 D477              ;  make_fst_ptr
0297 D477              ;
0298 D477              ;  fst_list_entry  <-  fst_list_ptr + (A * ff_size)
0299 D477              ;
0300 D477              ;  Inputs:      fst_list_ptr = ptr to list of available file systems
0301 D477              ;               A = index number of desired entry
0302 D477              ;
0303 D477              ;  Outputs:     fst_list_entry = ptr to desired entry
0304 D477              ;               A = trashed
0305 D477              ;               X = trashed
0306 D477              ;               Y = trashed
0307 D477              ;               P = nvmxdizc
0308 D477              ;                   ..000...
0309 D477              ;
0310 D477              ;==========================================================
0311 D477
0312 D477              make_fst_ptr Proc 
0313 D477                       with my_direct_page,fst_list_record
0314 D477
0315 D477 AA                    tax   
0316 D478 F0 0A                 beq   make_fst_ptr_2           ; if index == 0 then offset = 0
0317 D47A A9 00 00              lda   #0
0318 D47D
0319 D47D              make_fst_ptr_1  
0320 D47D 18                    clc   
0321 D47E 69 20 00              adc   #ff_size
0322 D481
0323 D481 CA                    dex   
0324 D482 D0 F9                 bne   make_fst_ptr_1
0325 D484
0326 D484              make_fst_ptr_2  
0327 D484 18                    clc   
0328 D485 65 94                 adc   <fst_list_ptr
0329 D487 85 98                 sta   <fst_list_entry
0330 D489 A9 00 00              lda   #0
0331 D48C 65 96                 adc   <fst_list_ptr+2
0332 D48E 85 9A                 sta   <fst_list_entry+2
0333 D490
0334 D490 60                    rts   
0335 D491
0336 D491                       EXPORT jsl_fst_ptr
0337 D491 20 77 D4     jsl_fst_ptr jsr   make_fst_ptr          ; so I can call from bank 1
0338 D494 6B                    rtl   
0339 D495
0340 D495                       EndP 
0341 D495
0342 D495                       eject 
0343 D495              ;==========================================================
0344 D495              ;
0345 D495              ;  cmp_fmt_fst
0346 D495              ;
0347 D495              ;  Compare a file system with a hard format and determine
0348 D495              ;  if they are compatible.
0349 D495              ;
0350 D495              ;  The rules are:
0351 D495              ;  (0)  if we are doing $25 ERASE_DISK, only the currently
0352 D495              ;               installed media is legal.
0353 D495              ;  (1)  flags:  one or both must be 0 (universal), OR
0354 D495              ;               the flags must match
0355 D495              ;  (2)  block count: driver block count must be within
0356 D495              ;               minimum and [maximum] specified by FST.
0357 D495              ;  (3)  block size: must match.
0358 D495              ;
0359 D495              ;  If they don't match, take a look at the alias field, because
0360 D495              ;  there might be another format which does.
0361 D495              ;
0362 D495              ;  Inputs:      fmt_list_entry = ptr to format in question
0363 D495              ;               fst_list_entry = ptr to file system in question
0364 D495              ;
0365 D495              ;  Outputs:     A = if C = 0, index # of selected FST
0366 D495              ;                   if C = 1, not valid
0367 D495              ;               X = trashed
0368 D495              ;               Y = trashed
0369 D495              ;               P = nvmxdizc
0370 D495              ;                   ..000..|
0371 D495              ;                          0 == compatible, 1 == incompatible
0372 D495              ;
0373 D495              ;  Uses:        init_temp_4
0374 D495              ;
0375 D495              ;==========================================================
0376 D495
0377 D495              cmp_fmt_fst Proc 
0378 D495                       with my_direct_page,fst_list_record,fmt_list_record
0379 D495
0380 D495 D4 88                 pei   <fmt_list_entry          ; record starting point
0381 D497 D4 8A                 pei   <fmt_list_entry+2
0382 D499
0383 D499              cmp_fmt_fst_0  
0384 D499 AD 02 D0              lda   |which_call              ; if FORMAT, all formats legal
0385 D49C F0 09                 beq   cmp_fmt_fst_05
0386 D49E
0387 D49E              ;  erase_disk, only current format is legal
0388 D49E
0389 D49E A0 0E 00              ldy   #df_conf_num             ; get driver's number
0390 D4A1 B7 88                 lda   [<fmt_list_entry],y
0391 D4A3 C5 A0                 cmp   <fmt_cur_med
0392 D4A5 D0 55                 bne   cmp_fmt_fst_no
0393 D4A7
0394 D4A7              cmp_fmt_fst_05  
0395 D4A7 A0 12 00              ldy   #df_flags
0396 D4AA B7 88                 lda   [<fmt_list_entry],y
0397 D4AC 29 03 00              and   #$0003
0398 D4AF F0 1E                 beq   cmp_fmt_fst_1            ; universal driver.  OK
0399 D4B1
0400 D4B1 A0 14 00              ldy   #ff_flags
0401 D4B4 57 98                 eor   [<fst_list_entry],y
0402 D4B6 29 03 00              and   #$0003
0403 D4B9 F0 14                 beq   cmp_fmt_fst_1            ; driver & fst match.  OK
0404 D4BB
0405 D4BB B7 98                 lda   [<fst_list_entry],y
0406 D4BD 29 03 00              and   #$0003
0407 D4C0 F0 0D                 beq   cmp_fmt_fst_1            ; universal fst, OK
0408 D4C2 C9 03 00              cmp   #$0003                   ; Apple ][ only?
0409 D4C5 D0 35                 bne   cmp_fmt_fst_no           ; nope, no match
0410 D4C7 A0 12 00              ldy   #df_flags                ; look at the device flags again
0411 D4CA B7 88                 lda   [<fmt_list_entry],y
0412 D4CC 4A                    lsr   a                        ; Apple-generic format?
0413 D4CD 90 2D                 bcc   cmp_fmt_fst_no           ; no, can't use it
0414 D4CF
0415 D4CF              ;  compare the block sizes.
0416 D4CF
0417 D4CF              cmp_fmt_fst_1  
0418 D4CF A0 18 00              ldy   #df_block_sz
0419 D4D2 B7 88                 lda   [<fmt_list_entry],y
0420 D4D4 A0 0A 00              ldy   #ff_block_sz
0421 D4D7 D7 98                 cmp   [<fst_list_entry],y
0422 D4D9 D0 21                 bne   cmp_fmt_fst_no
0423 D4DB
0424 D4DB              ;  compare the block count with the min & max.  this is messy
0425 D4DB              ;  because 4 byte comparisons.
0426 D4DB
0427 D4DB A0 14 00              ldy   #df_block_ct             ; get device block count
0428 D4DE B7 88                 lda   [<fmt_list_entry],y
0429 D4E0 85 B6                 sta   <init_temp_4
0430 D4E2 C8                    iny   
0431 D4E3 C8                    iny   
0432 D4E4 B7 88                 lda   [<fmt_list_entry],y
0433 D4E6 85 B8                 sta   <init_temp_4+2
0434 D4E8 A0 12 00              ldy   #ff_min_blocks+2
0435 D4EB
0436 D4EB D7 98                 cmp   [<fst_list_entry],y      ;is block count < min allowed?
0437 D4ED 90 0D                 blt   cmp_fmt_fst_no           ;yes - so no match
0438 D4EF D0 08                 bne   cmp_min_ok               ;it's > min allowed so OK
0439 D4F1 88                    dey   
0440 D4F2 88                    dey   
0441 D4F3 A5 B6                 lda   <init_temp_4
0442 D4F5 D7 98                 cmp   [<fst_list_entry],y
0443 D4F7 90 03                 blt   cmp_fmt_fst_no
0444 D4F9              cmp_min_ok                              ;block count >= min allowed
0445 D4F9
0446 D4F9              ;  match!  return carry clear
0447 D4F9
0448 D4F9 18                    clc   
0449 D4FA 80 22                 bra   cmp_fmt_fst_y
0450 D4FC
0451 D4FC              ;  no match.  if alias, loop.  If none, return carry clear
0452 D4FC
0453 D4FC              cmp_fmt_fst_no  
0454 D4FC A0 10 00              ldy   #df_alias
0455 D4FF B7 88                 lda   [<fmt_list_entry],y
0456 D501 F0 1A                 beq   cmp_fmt_fst_x
0457 D503 85 B6                 sta   <init_temp_4             ; must look for this entry
0458 D505 64 B8                 stz   <init_temp_4+2           ; counter
0459 D507
0460 D507              cmp_fmt_fst_lp  
0461 D507 A5 B8                 lda   <init_temp_4+2
0462 D509 20 59 D4              jsr   make_fmt_ptr
0463 D50C A0 0E 00              ldy   #df_conf_num
0464 D50F B7 88                 lda   [<fmt_list_entry],y
0465 D511 C5 B6                 cmp   <init_temp_4
0466 D513 F0 84                 beq   cmp_fmt_fst_0            ; found alias!
0467 D515
0468 D515 E6 B8                 inc   <init_temp_4+2
0469 D517 A5 B8                 lda   <init_temp_4+2
0470 D519 C5 8E                 cmp   <fmt_total_cnt
0471 D51B D0 EA                 bne   cmp_fmt_fst_lp
0472 D51D
0473 D51D              cmp_fmt_fst_x  
0474 D51D 38                    sec   
0475 D51E
0476 D51E              cmp_fmt_fst_y  
0477 D51E A0 06 00              ldy   #df_refnum               ; get the refnum
0478 D521 B7 88                 lda   [<fmt_list_entry],y
0479 D523
0480 D523 FA                    plx                            ; restore starting point
0481 D524 86 8A                 stx   <fmt_list_entry+2
0482 D526 FA                    plx   
0483 D527 86 88                 stx   <fmt_list_entry
0484 D529 60                    rts   
0485 D52A                       EndP 
0486 D52A
0487 D52A                       eject 
0488 D52A              ;==========================================================
0489 D52A              ;
0490 D52A              ;  deref_lists
0491 D52A              ;
0492 D52A              ;  fmt_list_vp  ->  fmt_list_ptr
0493 D52A              ;  fst_list_vp  ->  fst_list_ptr
0494 D52A              ;
0495 D52A              ;  Inputs:      fmt_list_vp = VP of available formats
0496 D52A              ;               fst_list_vp = VP of available file systems.
0497 D52A              ;
0498 D52A              ;  Outputs:     A = trashed
0499 D52A              ;               X = trashed
0500 D52A              ;               Y = trashed
0501 D52A              ;               P = nvmxdizc
0502 D52A              ;                   ..000...
0503 D52A              ;
0504 D52A              ;==========================================================
0505 D52A
0506 D52A              jsl_deref Proc Export
0507 D52A                       Import deref_lists
0508 D52A
0509 D52A 22 77 D2 01           jsl   deref_lists              ; so I can call into bank 1
0510 D52E 60                    rts   
0511 D52F                       EndP 
0512 D52F
0513 D52F                       eject 
0514 D52F              ;==========================================================
0515 D52F              ;
0516 D52F              ;  find_matches
0517 D52F              ;
0518 D52F              ;  First, for each file system, build a list of all applicable
0519 D52F              ;  formatting options.  Then, for each format, find the
0520 D52F              ;  number of the first applicable file system.  If no matches
0521 D52F              ;  are found for a particular entry, make it non-selectable (dim).
0522 D52F              ;  If no matches are found in the entire group, formatting is
0523 D52F              ;  impossible.
0524 D52F              ;
0525 D52F              ;  Inputs:      fmt_list_vp = VP of available formats
0526 D52F              ;               fst_list_vp = VP of available file systems.
0527 D52F              ;
0528 D52F              ;  Outputs:     A = error code if C == 1
0529 D52F              ;               X = trashed
0530 D52F              ;               Y = trashed
0531 D52F              ;               P = nvmxdizc
0532 D52F              ;                   ..000..|
0533 D52F              ;                          0=no error, 1=no matches found
0534 D52F              ;
0535 D52F              ;  This routine may move memory.
0536 D52F              ;
0537 D52F              ;==========================================================
0538 D52F
0539 D52F              find_matches Proc Export
0540 D52F                       with my_direct_page,fst_list_record,fmt_list_record
0541 D52F                       Import pb_reqFileSysID,pb_flags
0542 D52F
0543 D52F              ;  for each fst, check all formats
0544 D52F
0545 D52F 64 AA                 stz   <init_temp_1             ; fst counter
0546 D531 64 B2                 stz   <init_temp_3             ; match counter
0547 D533
0548 D533              ;  loop here through file systems
0549 D533
0550 D533              find_matches_1  
0551 D533 A5 8C                 lda   <fmt_disp_cnt            ; get memory for the list
0552 D535 0A                    asl   a                        ; word entries
0553 D536 38                    sec   
0554 D537 22 00 D4 00           jsl   call_alloc
0555 D53B 5A                    phy   
0556 D53C DA                    phx   
0557 D53D
0558 D53D 20 2A D5              jsr   jsl_deref                ; make ptrs
0559 D540 A5 AA                 lda   <init_temp_1
0560 D542 20 77 D4              jsr   make_fst_ptr
0561 D545
0562 D545 A0 18 00              ldy   #ff_match_lst            ; install vp of list into fst rec
0563 D548 68                    pla   
0564 D549 97 98                 sta   [<fst_list_entry],y
0565 D54B AA                    tax   
0566 D54C C8                    iny   
0567 D54D C8                    iny   
0568 D54E 68                    pla   
0569 D54F 97 98                 sta   [<fst_list_entry],y
0570 D551 A8                    tay   
0571 D552 22 08 D4 00           jsl   call_deref               ; make ptr to new list
0572 D556 86 AE                 stx   <init_temp_2
0573 D558 84 B0                 sty   <init_temp_2+2
0574 D55A
0575 D55A 64 AC                 stz   <init_temp_1+2           ; fmt counter
0576 D55C
0577 D55C              ;  loop here through formats, checking against the current fst
0578 D55C
0579 D55C              find_matches_2  
0580 D55C A5 AC                 lda   <init_temp_1+2
0581 D55E 20 59 D4              jsr   make_fmt_ptr
0582 D561
0583 D561 20 95 D4              jsr   cmp_fmt_fst              ; are they compatible?
0584 D564 B0 11                 bcs   find_matches_3           ; no.
0585 D566
0586 D566              ;  compatible.  insert fmt index in fst's list
0587 D566
0588 D566 A0 16 00              ldy   #ff_match_ct
0589 D569 B7 98                 lda   [<fst_list_entry],y
0590 D56B 1A                    inc   a
0591 D56C 97 98                 sta   [<fst_list_entry],y
0592 D56E 3A                    dec   a
0593 D56F 0A                    asl   a
0594 D570 A8                    tay   
0595 D571 A5 AC                 lda   <init_temp_1+2
0596 D573 97 AE                 sta   [<init_temp_2],y
0597 D575
0598 D575 E6 B2                 inc   <init_temp_3             ; flag successes
0599 D577
0600 D577              ;  move to next fmt
0601 D577
0602 D577              find_matches_3  
0603 D577 E6 AC                 inc   <init_temp_1+2
0604 D579 A5 AC                 lda   <init_temp_1+2
0605 D57B C5 8C                 cmp   <fmt_disp_cnt
0606 D57D D0 DD                 bne   find_matches_2
0607 D57F
0608 D57F              ;  Dim if no matches found.  Move to next fst
0609 D57F
0610 D57F A0 16 00              ldy   #ff_match_ct
0611 D582 B7 98                 lda   [<fst_list_entry],y
0612 D584 D0 08                 bne   find_matches_35
0613 D586 A0 04 00              ldy   #ff_mem_flag
0614 D589 A9 60 00              lda   #%01100000               ; disable & inactive bits
0615 D58C 97 98                 sta   [<fst_list_entry],y
0616 D58E
0617 D58E              find_matches_35  
0618 D58E E6 AA                 inc   <init_temp_1
0619 D590 A5 AA                 lda   <init_temp_1
0620 D592 C5 9C                 cmp   <fst_list_cnt
0621 D594 D0 9D                 bne   find_matches_1
0622 D596
0623 D596              ;  now do the whole thing over but searching for a single fst
0624 D596              ;  to match each format.
0625 D596
0626 D596 64 AA                 stz   <init_temp_1             ; fmt counter
0627 D598
0628 D598              ;  loop here through formatting options
0629 D598
0630 D598              find_matches_4  
0631 D598 A5 AA                 lda   <init_temp_1
0632 D59A 20 59 D4              jsr   make_fmt_ptr
0633 D59D
0634 D59D 64 AC                 stz   <init_temp_1+2           ; fst counter
0635 D59F
0636 D59F              ;  loop here through file systems, checking against the current format
0637 D59F
0638 D59F              find_matches_5  
0639 D59F A5 AC                 lda   <init_temp_1+2
0640 D5A1 20 77 D4              jsr   make_fst_ptr
0641 D5A4
0642 D5A4 20 95 D4              jsr   cmp_fmt_fst              ; are they compatible?
0643 D5A7 90 12                 bcc   find_matches_6           ; yes
0644 D5A9
0645 D5A9              ;  no match.  try next file system
0646 D5A9
0647 D5A9 E6 AC                 inc   <init_temp_1+2
0648 D5AB A5 AC                 lda   <init_temp_1+2
0649 D5AD C5 9C                 cmp   <fst_list_cnt
0650 D5AF D0 EE                 bne   find_matches_5
0651 D5B1
0652 D5B1              ;  no fst matches this format.  disable it
0653 D5B1
0654 D5B1 A0 04 00              ldy   #df_mem_flag
0655 D5B4 A9 60 00              lda   #%01100000               ; disable & inactive bits
0656 D5B7 97 88                 sta   [<fmt_list_entry],y
0657 D5B9 80 09                 bra   find_matches_7
0658 D5BB
0659 D5BB              ;  compatible.  insert fst index in fmt record
0660 D5BB
0661 D5BB              find_matches_6  
0662 D5BB A0 08 00              ldy   #df_one_fst
0663 D5BE A5 AC                 lda   <init_temp_1+2           ; index # of this fst
0664 D5C0 97 88                 sta   [<fmt_list_entry],y
0665 D5C2
0666 D5C2 E6 B2                 inc   <init_temp_3             ; flag successes
0667 D5C4
0668 D5C4              ;  move to next fmt
0669 D5C4
0670 D5C4              find_matches_7  
0671 D5C4 E6 AA                 inc   <init_temp_1
0672 D5C6 A5 AA                 lda   <init_temp_1
0673 D5C8 C5 8C                 cmp   <fmt_disp_cnt
0674 D5CA D0 CC                 bne   find_matches_4
0675 D5CC
0676 D5CC              ;  all done.  return error if no lists built
0677 D5CC
0678 D5CC A2 2B 00              ldx   #drvr_wr_prot            ; assume error
0679 D5CF A5 B2                 lda   <init_temp_3
0680 D5D1 D0 03                 bne   find_matches_8
0681 D5D3              error     
0682 D5D3 8A                    txa                            ; put error code in accumulator
0683 D5D4 38                    sec   
0684 D5D5 60                    rts   
0685 D5D6
0686 D5D6              find_matches_8  
0687 D5D6 AD 4C D2              lda   pb_reqFileSysID          ; valid ID supplied?
0688 D5D9 F0 33                 beq   @skip_check              ; no, must be selectable
0689 D5DB
0690 D5DB              ; The caller supplied an FST ID that they want us to use for the format. Therefore,
0691 D5DB              ; we should probably check the supplied ID to make sure that it's in our list of FSTs
0692 D5DB              ; that support formatting.  If not, we either return an InvalidFSTop error code (if the
0693 D5DB              ; FST is not selectable), or we zero the reqFileSysID variable so that the default FST
0694 D5DB              ; is automatically selected.
0695 D5DB
0696 D5DB A9 00 00              lda   #0
0697 D5DE 85 AA                 sta   <init_temp_1
0698 D5E0              @loop     
0699 D5E0 20 77 D4              jsr   make_fst_ptr
0700 D5E3 A0 08 00              ldy   #ff_fs_num               ; get the FST ID from the record
0701 D5E6 B7 98                 lda   [<fst_list_entry],y
0702 D5E8 CD 4C D2              cmp   pb_reqFileSysID          ; do they match?
0703 D5EB F0 17                 beq   @found_it                ; yes, go check the format count
0704 D5ED              @next_one  
0705 D5ED E6 AA                 inc   init_temp_1              ; bump counter
0706 D5EF A5 AA                 lda   init_temp_1              ; are we done yet?
0707 D5F1 C5 9C                 cmp   fst_list_cnt
0708 D5F3 D0 EB                 bne   @loop                    ; no, go do the next one
0709 D5F5 2C 4E D2              bit   pb_flags                 ; selectable FST?
0710 D5F8 70 05                 bvs   @set_id                  ; yes, just ignore
0711 D5FA A2 65 00              ldx   #invalid_fst_op          ; FST not found in the list
0712 D5FD 80 D4                 bra   error
0713 D5FF              @set_id   
0714 D5FF 9C 4C D2              stz   pb_reqFileSysID          ; clear the variable
0715 D602 80 0A                 bra   @skip_check
0716 D604              @found_it  
0717 D604 A2 65 00              ldx   #invalid_fst_op          ; preset error code
0718 D607 A0 16 00              ldy   #ff_match_ct             ; get the format match count for this FST
0719 D60A B7 98                 lda   [<fst_list_entry],y      ; if there's no compatible format,
0720 D60C F0 C5                 beq   error                    ;   then we error out
0721 D60E              @skip_check  
0722 D60E A9 00 00              lda   #0                       ; no error
0723 D611 18                    clc   
0724 D612 60                    rts   
0725 D613
0726 D613                       EndP 
0727 D613
0728 D613                       eject 
0729 D613              ;==========================================================
0730 D613              ;
0731 D613              ;  jsl chk_fst_size
0732 D613              ;
0733 D613              ;  Formatting FST's onto 'too-large' volumes is allowed ;
0734 D613              ;  but a warning is presented if this is true to remind
0735 D613              ;  the user that they are a bozo.
0736 D613              ;
0737 D613              ;  Inputs:      fst_list_entry = currently selected fst
0738 D613              ;               fmt_list_entry = currently selected fmt
0739 D613              ;
0740 D613              ;  Outputs:     A = trashed
0741 D613              ;               X = trashed
0742 D613              ;               Y = trashed
0743 D613              ;               P = nvmxdizc
0744 D613              ;                   ..000..|
0745 D613              ;                          0 = fst fits format
0746 D613              ;                          1 = format too big
0747 D613              ;
0748 D613              ;==========================================================
0749 D613
0750 D613              chk_fst_size Proc Export
0751 D613                       with my_direct_page,fst_list_record,fmt_list_record
0752 D613
0753 D613 20 95 D4              jsr   cmp_fmt_fst              ; I know they match.  This points us
0754 D616 20 59 D4              jsr   make_fmt_ptr             ; to the actual fmt (if alias'd)
0755 D619
0756 D619              ;  Now compare the block counts
0757 D619
0758 D619 A0 0E 00              ldy   #ff_max_blocks+2
0759 D61C B7 98                 lda   [<fst_list_entry],y
0760 D61E A0 16 00              ldy   #df_block_ct+2
0761 D621 D7 88                 cmp   [<fmt_list_entry],y
0762 D623 90 10                 blt   chk_fst_err              ; too big in hi word
0763 D625 D0 0C                 bne   chk_fst_ok               ; smaller in hi word
0764 D627
0765 D627 A0 0C 00              ldy   #ff_max_blocks           ; hi word is equal if get here
0766 D62A B7 98                 lda   [<fst_list_entry],y
0767 D62C A0 14 00              ldy   #df_block_ct
0768 D62F D7 88                 cmp   [<fmt_list_entry],y
0769 D631 90 02                 blt   chk_fst_err              ; too big in lo word
0770 D633              chk_fst_ok  
0771 D633 18                    clc   
0772 D634 6B                    rtl   
0773 D635
0774 D635              chk_fst_err  
0775 D635 38                    sec   
0776 D636 6B                    rtl   
0777 D637                       EndP 
0778 D637
0779 D637                       eject 
0780 D637              ;==========================================================
0781 D637              ;
0782 D637              ;  set_driver_fmt
0783 D637              ;
0784 D637              ;  Transmit a selected hard format option to the driver.
0785 D637              ;  There is no error checking, because if the driver has
0786 D637              ;  no options, it simply ignores the call.
0787 D637              ;
0788 D637              ;  Inputs:      chosen_fmt = my refnum of chosen format
0789 D637              ;               dev_num = driver number
0790 D637              ;
0791 D637              ;  Outputs:     A = trashed
0792 D637              ;               X = trashed
0793 D637              ;               Y = trashed
0794 D637              ;               P = nvmxdizc
0795 D637              ;                   ..000...
0796 D637              ;
0797 D637              ;==========================================================
0798 D637
0799 D637              set_driver_fmt Proc Export
0800 D637                       with my_direct_page,fmt_list_record
0801 D637
0802 D637 20 2A D5              jsr   jsl_deref                ; convert my ref# to drivers ref#
0803 D63A A5 A4                 lda   <chosen_fmt
0804 D63C 20 59 D4              jsr   make_fmt_ptr
0805 D63F
0806 D63F A0 0E 00              ldy   #df_conf_num
0807 D642 B7 88                 lda   [<fmt_list_entry],y
0808 D644 85 AA                 sta   <init_temp_1             ; becomes the control list
0809 D646
0810 D646 A9 AA BD              lda   #direct_base+init_temp_1
0811 D649 85 04                 sta   <drvr_clist_ptr
0812 D64B 64 06                 stz   <drvr_clist_ptr+2
0813 D64D
0814 D64D A5 36                 lda   <dev_num
0815 D64F 85 00                 sta   <drvr_dev_num
0816 D651 A9 06 00              lda   #$0006                   ; 6 = 'control'
0817 D654 85 02                 sta   <drvr_call_num
0818 D656 3A                    dec   a                        ; 5 = 'set format options'
0819 D657 85 16                 sta   <drvr_ctrl_code
0820 D659 A9 02 00              lda   #2
0821 D65C 85 08                 sta   <drvr_req_cnt
0822 D65E 64 0A                 stz   <drvr_req_cnt+2
0823 D660 22 18 D4 00           jsl   call_dispatch
0824 D664
0825 D664 60                    rts   
0826 D665                       EndP 
0827 D665
0828 D665                       eject 
0829 D665              ;==========================================================
0830 D665              ;
0831 D665              ;  grx_too_big
0832 D665              ;
0833 D665              ;  If the current fst is not big enough for the current
0834 D665              ;  format, we will let them format, but we give them a
0835 D665              ;  nasty note.
0836 D665              ;
0837 D665              ;  e.g. ProDOS (32Mb max) onto an HD40SC.
0838 D665              ;
0839 D665              ;  Outputs:     A = trashed
0840 D665              ;               X = trashed
0841 D665              ;               Y = trashed
0842 D665              ;               P = nvmxdizc
0843 D665              ;                   ..000...
0844 D665              ;
0845 D665              ;==========================================================
0846 D665
0847 D665              grx_too_big Proc 
0848 D665                       Import draw_caution
0849 D665                       with my_direct_page
0850 D665
0851 D665 20 40 D4              jsr   nextmember_1             ; fst selected?
0852 D668 F0 26                 beq   grx_clr_warn             ; nothing selected
0853 D66A
0854 D66A 3A                    dec   a                        ; fix ListMgr's item number
0855 D66B 20 77 D4              jsr   make_fst_ptr             ; fill in fst_list_entry
0856 D66E 20 46 D4              jsr   nextmember_2             ; fmt selected?
0857 D671 F0 1C                 beq   no_change                ; nothing selected
0858 D673 3A                    dec   a                        ; fix ListMgr's item number
0859 D674 20 59 D4              jsr   make_fmt_ptr             ; fill in fmt_list_entry
0860 D677
0861 D677              ;  find out if the current pair is ok
0862 D677
0863 D677 22 13 D6 00           jsl   chk_fst_size             ; fills the string if a problem
0864 D67B 90 12                 bcc   no_change
0865 D67D
0866 D67D              ;  display the warning
0867 D67D
0868 D67D              grx_show_warn  
0869 D67D A9 DC FF              lda   #28-64                   ; message # - 64
0870 D680 CD 1E D0              cmp   currentFST               ; is the message already displayed?
0871 D683 F0 0A                 beq   no_change                ; yes, don't bother redisplaying
0872 D685 8D 1E D0              sta   currentFST               ; update message #
0873 D688 A9 1C 00              lda   #28                      ; get the real message #
0874 D68B 20 0A DA              jsr   draw_caution             ; go draw the message
0875 D68E 38                    sec                            ; signify that we put up the message
0876 D68F              no_change  
0877 D68F 60                    rts   
0878 D690
0879 D690
0880 D690              ;  everybody happy.  No warning
0881 D690                       Entry grx_clr_warn
0882 D690              grx_clr_warn  
0883 D690 F4 01 00              pea   warn_rect>>16            ; bounding box
0884 D693 F4 E0 D0              pea   warn_rect
0885 D696 A2 04 55              ldx   #$5504                   ; EraseRect
0886 D699 20 36 D4              jsr   call_tools_0
0887 D69C 9C 1E D0              stz   currentFST               ; clear message area
0888 D69F 18                    clc                            ; no message is displayed now
0889 D6A0 60                    rts   
0890 D6A1
0891 D6A1                       EndP 
0892 D6A1
0893 D6A1                       eject 
0894 D6A1              ;==========================================================
0895 D6A1              ;
0896 D6A1              ;  setup_screen1
0897 D6A1              ;  setup_screen2
0898 D6A1              ;
0899 D6A1              ;  Examine the current configuration of the system to
0900 D6A1              ;  determine if we can legally use the graphics based
0901 D6A1              ;  interface.  If not, we will have to create a text
0902 D6A1              ;  based interface using the console driver.
0903 D6A1              ;
0904 D6A1              ;  Outputs:     init_screen = -1 = graphics
0905 D6A1              ;                              0 = text
0906 D6A1              ;               A = trashed
0907 D6A1              ;               X = trashed
0908 D6A1              ;               Y = trashed
0909 D6A1              ;               P = nvmxdizc
0910 D6A1              ;                   ..000...
0911 D6A1              ;
0912 D6A1              ;==========================================================
0913 D6A1
0914 D6A1              setup_screen1 Proc Export
0915 D6A1                       with my_direct_page
0916 D6A1
0917 D6A1 64 A8                 stz   <init_screen             ;init to text mode
0918 D6A3
0919 D6A3 48                    pha   
0920 D6A4 A2 05 06              ldx   #$0605                   ; DeskStatus
0921 D6A7 20 36 D4              jsr   call_tools_0
0922 D6AA 68                    pla   
0923 D6AB F0 36                 beq   setup_text
0924 D6AD
0925 D6AD F4 00 00              pea   0                        ; in case list mgr isn't loaded
0926 D6B0 A2 1C 06              ldx   #$061C                   ; ListStatus
0927 D6B3 20 36 D4              jsr   call_tools_0
0928 D6B6 68                    pla   
0929 D6B7 F0 2A                 beq   setup_text
0930 D6B9
0931 D6B9 E2 20                 sep   #$20                     ; 8 bit accum.
0932 D6BB AD 29 C0              lda   |$C029                   ; new_video
0933 D6BE C2 20                 rep   #$20
0934 D6C0 29 80 00              and   #$0080                   ; super high res on?
0935 D6C3 F0 1E                 beq   setup_text
0936 D6C5
0937 D6C5 48                    pha                            ; result space
0938 D6C6 A2 04 17              ldx   #$1704                   ; GetMasterSCB
0939 D6C9 20 36 D4              jsr   call_tools_0
0940 D6CC 68                    pla   
0941 D6CD 29 80 00              and   #%10000000               ; 320 or 640 mode?
0942 D6D0 F0 11                 beq   setup_text               ; 320, use text mode
0943 D6D2
0944 D6D2 48                    pha   
0945 D6D3 48                    pha   
0946 D6D4 A2 02 2F              ldx   #$2F02                   ; RealFreeMem
0947 D6D7 20 36 D4              jsr   call_tools_0
0948 D6DA 68                    pla   
0949 D6DB 68                    pla   
0950 D6DC C9 01 00              cmp   #$0001                   ; 64k available?
0951 D6DF 90 02                 blt   setup_text
0952 D6E1
0953 D6E1 C6 A8                 dec   <init_screen             ; passed all tests so use graphics mode
0954 D6E3
0955 D6E3 60           setup_text rts   
0956 D6E4                       EndP 
0957 D6E4              ;----------------------------------------------------------
0958 D6E4
0959 D6E4              setup_screen2 Proc Export
0960 D6E4                       Import gsos_id
0961 D6E4                       with my_direct_page
0962 D6E4
0963 D6E4              ;  try to get a 1k stack for the grx routines.
0964 D6E4
0965 D6E4 A9 00 00              lda   #0
0966 D6E7 48                    pha                            ; returns long
0967 D6E8 48                    pha   
0968 D6E9 48                    pha                            ; size $00000400  (1k)
0969 D6EA F4 00 04              pea   $400
0970 D6ED AF E2 B9 00           lda   >gsos_id                 ; use Mike's memory ID
0971 D6F1 48                    pha   
0972 D6F2 F4 11 C0              pea   $C011                    ; locked,no bank cross,spec. bank
0973 D6F5 A9 00 00              lda   #0
0974 D6F8 48                    pha                            ; must be bank 0
0975 D6F9 48                    pha   
0976 D6FA A2 02 09              ldx   #$0902                   ; NewHandle
0977 D6FD 20 36 D4              jsr   call_tools_0
0978 D700
0979 D700 68                    pla   
0980 D701 85 BC                 sta   <init_window             ; cached here for now
0981 D703 68                    pla   
0982 D704 85 BE                 sta   <init_window+2
0983 D706 90 02                 bcc   got_grx_stack
0984 D708 64 A8                 stz   <init_screen             ; didn't get mem so use text mode
0985 D70A 60           got_grx_stack rts   
0986 D70B                       EndP 
0987 D70B
0988 D70B                       eject 
0989 D70B              ;==========================================================
0990 D70B              ;
0991 D70B              ;  set_grx_stack
0992 D70B              ;
0993 D70B              ;  Many of the toolbox routines require more stack space
0994 D70B              ;  than is provided by GS/OS.  The screen chooser has
0995 D70B              ;  reserved 1k for me and cached its handle at <init_window.
0996 D70B              ;
0997 D70B              ;  Inputs:      GS/OS stack: |  ret addr  |  of my caller
0998 D70B              ;                            |-          -|
0999 D70B              ;                            |            | <- SP
1000 D70B              ;
1001 D70B              ;  Outputs:     New stack:   |  GS/OS SP  |
1002 D70B              ;                            |-          -|
1003 D70B              ;                            |  ret addr  | of my caller
1004 D70B              ;                            |-          -|
1005 D70B              ;                            |            | <- SP
1006 D70B              ;               A = trashed
1007 D70B              ;               X = trashed
1008 D70B              ;               Y = trashed
1009 D70B              ;               P = nvmxdizc
1010 D70B              ;                   ..000...
1011 D70B              ;
1012 D70B              ;  This routine may move memory.
1013 D70B              ;
1014 D70B              ;==========================================================
1015 D70B
1016 D70B              set_grx_stack Proc 
1017 D70B                       with my_direct_page
1018 D70B
1019 D70B A7 BC                 lda   [<init_window]           ; the base of the new stack
1020 D70D 18                    clc   
1021 D70E 69 FF 03              adc   #$03FF                   ; and this is the new SP
1022 D711 85 BC                 sta   <init_window
1023 D713
1024 D713 FA                    plx                            ; get return addr
1025 D714 3B                    tsc   
1026 D715 A8                    tay   
1027 D716 A5 BC                 lda   <init_window
1028 D718 1B                    tcs                            ; set to new stack
1029 D719 5A                    phy                            ; push old sp
1030 D71A DA                    phx                            ; push ret addr
1031 D71B 60                    rts   
1032 D71C                       EndP 
1033 D71C
1034 D71C                       eject 
1035 D71C              ;==========================================================
1036 D71C              ;
1037 D71C              ;  reset_grx_stack
1038 D71C              ;
1039 D71C              ;  Switch back to the normal GS/OS stack.
1040 D71C              ;
1041 D71C              ;  Inputs:      New stack:   |  GS/OS SP  |
1042 D71C              ;                            |-          -|
1043 D71C              ;                            |  ret addr  | of my caller
1044 D71C              ;                            |-          -|
1045 D71C              ;                            |            | <- SP
1046 D71C              ;
1047 D71C              ;  Outputs:     GS/OS stack: |  ret addr  |  of my caller
1048 D71C              ;                            |-          -|
1049 D71C              ;                            |            | <- SP
1050 D71C              ;               A = trashed
1051 D71C              ;               X = trashed
1052 D71C              ;               Y = trashed
1053 D71C              ;               P = nvmxdizc
1054 D71C              ;                   ..000...
1055 D71C              ;
1056 D71C              ;==========================================================
1057 D71C
1058 D71C              reset_grx_stack Proc 
1059 D71C                       with my_direct_page
1060 D71C
1061 D71C 68                    pla                            ; store return addr
1062 D71D 85 AA                 sta   <init_temp_1
1063 D71F 68                    pla                            ; store GS/OS stack addr
1064 D720 85 AC                 sta   <init_temp_1+2
1065 D722
1066 D722 3B                    tsc                            ; find handle for my stack
1067 D723 48                    pha   
1068 D724 48                    pha   
1069 D725 F4 00 00              pea   0                        ; always bank 0
1070 D728 48                    pha   
1071 D729 A2 02 1A              ldx   #$1A02                   ; FindHandle
1072 D72C 20 36 D4              jsr   call_tools_0
1073 D72F FA                    plx                            ; save it
1074 D730 7A                    ply   
1075 D731 A5 AC                 lda   <init_temp_1+2           ; restore GS/OS stack
1076 D733 1B                    tcs   
1077 D734 5A                    phy                            ; then dump the 1k stack
1078 D735 DA                    phx   
1079 D736 A2 02 10              ldx   #$1002                   ; DisposeHandle
1080 D739 20 36 D4              jsr   call_tools_0
1081 D73C D4 AA                 pei   <init_temp_1             ; return address
1082 D73E 60                    rts   
1083 D73F                       EndP 
1084 D73F
1085 D73F                       eject 
1086 D73F              ;==========================================================
1087 D73F              ;
1088 D73F              ;  fix_cursor
1089 D73F              ;  restore_cursor
1090 D73F              ;
1091 D73F              ;  Often the calling application sets the cursor to the
1092 D73F              ;  'watch' cursor because init can be a time consuming
1093 D73F              ;  operation.  For the purposes of my interface, I need
1094 D73F              ;  a pointer.
1095 D73F              ;
1096 D73F              ;  'fix_cursor' stores the current state of the cursor
1097 D73F              ;  and replaces it with the standard pointer.
1098 D73F              ;
1099 D73F              ;  Outputs:     save_cursor = pointer to old cursor record
1100 D73F              ;               A = trashed
1101 D73F              ;               X = trashed
1102 D73F              ;               Y = trashed
1103 D73F              ;               P = nvmxdizc
1104 D73F              ;                   ..000...
1105 D73F              ;
1106 D73F              ;  'restore_cursor' puts it back to whatever the application
1107 D73F              ;  wanted.
1108 D73F              ;
1109 D73F              ;  Inputs:      save_cursor = pointer to original cursor
1110 D73F              ;
1111 D73F              ;  Outputs:     A = trashed
1112 D73F              ;               X = trashed
1113 D73F              ;               Y = trashed
1114 D73F              ;               P = nvmxdizc
1115 D73F              ;                   ..000...
1116 D73F              ;
1117 D73F              ;==========================================================
1118 D73F
1119 D73F              fix_cursor Proc 
1120 D73F                       Import save_cursor
1121 D73F
1122 D73F 48                    pha   
1123 D740 48                    pha   
1124 D741 A2 04 8F              ldx   #$8F04                   ; GetCursorAdr
1125 D744 20 36 D4              jsr   call_tools_0
1126 D747 68                    pla   
1127 D748 8D 06 D0              sta   |save_cursor
1128 D74B 68                    pla   
1129 D74C 8D 08 D0              sta   |save_cursor+2
1130 D74F
1131 D74F A2 04 CA              ldx   #$CA04                   ; InitCursor
1132 D752 20 36 D4              jsr   call_tools_0
1133 D755
1134 D755 60                    rts   
1135 D756
1136 D756                       Entry restore_cursor
1137 D756              restore_cursor  
1138 D756 AD 08 D0              lda   |save_cursor+2
1139 D759 48                    pha   
1140 D75A AD 06 D0              lda   |save_cursor
1141 D75D 48                    pha   
1142 D75E A2 04 8E              ldx   #$8E04
1143 D761 20 36 D4              jsr   call_tools_0
1144 D764
1145 D764 60                    rts   
1146 D765                       EndP 
1147 D765
1148 D765                       eject 
1149 D765              ;==========================================================
1150 D765              ;
1151 D765              ;  fix_ptrs
1152 D765              ;
1153 D765              ;  (1)  lock down GS/OS memory so ptrs stay the same
1154 D765              ;
1155 D765              ;  (2)  Loop through format list, making pointers to
1156 D765              ;       the strings.
1157 D765              ;
1158 D765              ;  Outputs:     A = trashed
1159 D765              ;               X = trashed
1160 D765              ;               Y = trashed
1161 D765              ;               P = nvmxdizc
1162 D765              ;                   ..000..0
1163 D765              ;
1164 D765              ;==========================================================
1165 D765
1166 D765              fix_ptrs Proc Export
1167 D765                       with my_direct_page,fmt_list_record
1168 D765
1169 D765 22 20 D4 00           jsl   call_lock_mem
1170 D769
1171 D769 20 2A D5              jsr   jsl_deref
1172 D76C 64 AA                 stz   <init_temp_1             ; entry counter
1173 D76E
1174 D76E              fix_ptrs_lp  
1175 D76E A5 AA                 lda   <init_temp_1
1176 D770 20 59 D4              jsr   make_fmt_ptr
1177 D773 A0 0A 00              ldy   #df_string               ; get the vp
1178 D776 B7 88                 lda   [<fmt_list_entry],y
1179 D778 AA                    tax   
1180 D779 C8                    iny   
1181 D77A C8                    iny   
1182 D77B B7 88                 lda   [<fmt_list_entry],y
1183 D77D A8                    tay   
1184 D77E 22 08 D4 00           jsl   call_deref
1185 D782 98                    tya   
1186 D783 A0 02 00              ldy   #df_mem_ptr+2
1187 D786 97 88                 sta   [<fmt_list_entry],y
1188 D788 88                    dey   
1189 D789 88                    dey   
1190 D78A 8A                    txa   
1191 D78B 97 88                 sta   [<fmt_list_entry],y
1192 D78D
1193 D78D E6 AA                 inc   <init_temp_1
1194 D78F A5 AA                 lda   <init_temp_1
1195 D791 C5 8C                 cmp   <fmt_disp_cnt
1196 D793 D0 D9                 bne   fix_ptrs_lp
1197 D795
1198 D795 6B                    rtl   
1199 D796                       EndP 
1200 D796
1201 D796                       eject 
1202 D796              ;==========================================================
1203 D796              ;
1204 D796              ;  setup_window
1205 D796              ;
1206 D796              ;  Create the window for the init dialog.  Also adds the
1207 D796              ;  first two controls, 'ok' and 'cancel'.
1208 D796              ;
1209 D796              ;  Outputs:     init_window = grafport of the window
1210 D796              ;               A = trashed
1211 D796              ;               X = trashed
1212 D796              ;               Y = trashed
1213 D796              ;               P = nvmxdizc
1214 D796              ;                   ..000..0
1215 D796              ;
1216 D796              ;  This routine may move memory.
1217 D796              ;
1218 D796              ;==========================================================
1219 D796
1220 D796              setup_window Proc 
1221 D796                       Import MyControls,name_default,subArray
1222 D796                       Import cancel_title,dflt_title,editLine
1223 D796                       Import init_wnd_parms,pb_flags
1224 D796
1225 D796                       with my_direct_page
1226 D796
1227 D796              ; create the window
1228 D796
1229 D796 48                    pha                            ; returns ptr to it
1230 D797 48                    pha   
1231 D798 F4 01 00              pea   init_wnd_parms>>16
1232 D79B F4 44 D0              pea   init_wnd_parms
1233 D79E A2 0E 09              ldx   #$090E                   ; NewWindow
1234 D7A1 20 36 D4              jsr   call_tools_0
1235 D7A4 68                    pla   
1236 D7A5 85 BC                 sta   <init_window
1237 D7A7 68                    pla   
1238 D7A8 85 BE                 sta   <init_window+2
1239 D7AA
1240 D7AA              ; set up the volume name string pointer
1241 D7AA
1242 D7AA A5 3E                 lda   <path2_ptr               ; make pointer to volume name string
1243 D7AC 05 40                 ora   <path2_ptr+2             ; was a volume name supplied?
1244 D7AE D0 09                 bne   @set_it_up               ; yes, set the length byte
1245 D7B0 A9 3D 00              lda   #61                      ; get the default volume name string
1246 D7B3 22 50 D2 01           jsl   get_string
1247 D7B7 80 1A                 bra   @continue
1248 D7B9
1249 D7B9              @set_it_up  
1250 D7B9 A5 3E                 lda   <path2_ptr               ; make pointer to volume name string
1251 D7BB 18                    clc   
1252 D7BC 69 02 00              adc   #2                       ; point to $80 separator
1253 D7BF 85 AA                 sta   <init_temp_1
1254 D7C1 AA                    tax                            ; save in X
1255 D7C2 A5 40                 lda   <path2_ptr+2             ; high word too
1256 D7C4 69 00 00              adc   #0
1257 D7C7 85 AC                 sta   <init_temp_1+2
1258 D7C9 A8                    tay                            ; save in Y
1259 D7CA A7 3E                 lda   [<path2_ptr]             ; get the length word
1260 D7CC E2 20                 sep   #$20                     ; 8-bit accumulator
1261 D7CE 3A                    dec   a                        ; account for missing separator
1262 D7CF 87 AA                 sta   [<init_temp_1]           ; store on top of the $80
1263 D7D1 C2 20                 rep   #$20
1264 D7D3
1265 D7D3              @continue  
1266 D7D3 8E D0 D1              stx   name_default             ; store in control template
1267 D7D6 8C D2 D1              sty   name_default+2
1268 D7D9
1269 D7D9              ; set up pointers to the control strings
1270 D7D9 A2 17 00              ldx   #23                      ; get 'ok' string for Format call
1271 D7DC AD 02 D0              lda   which_call               ; was the call Format or Erase?
1272 D7DF F0 03                 beq   its_format               ; it was Format
1273 D7E1 A2 1E 00              ldx   #30                      ; get 'ok' string for Erase call
1274 D7E4 8A           its_format txa   
1275 D7E5 22 50 D2 01           jsl   get_string
1276 D7E9 8E 22 D1              stx   dflt_title
1277 D7EC 8C 24 D1              sty   dflt_title+2
1278 D7EF
1279 D7EF A9 18 00              lda   #24                      ; get 'cancel' string
1280 D7F2 22 50 D2 01           jsl   get_string
1281 D7F6 8E 4A D1              stx   cancel_title
1282 D7F9 8C 4C D1              sty   cancel_title+2
1283 D7FC
1284 D7FC              ; set up the list of control template pointers
1285 D7FC
1286 D7FC A2 00 D1              ldx   #myControls+16           ;just past pointers for required templates
1287 D7FF 2C 4E D2              bit   pb_flags                 ;editable volume name?
1288 D802 10 10                 bpl   @static_name             ;no...
1289 D804 A9 B4 D1              lda   #editLine                ;else put template pointer into list
1290 D807 9D 00 00              sta   |$0000,x
1291 D80A E8                    inx   
1292 D80B E8                    inx   
1293 D80C A9 01 00              lda   #^editLine
1294 D80F 9D 00 00              sta   |$0000,x
1295 D812 E8                    inx   
1296 D813 E8                    inx   
1297 D814              @static_name  
1298 D814 9E 00 00              stz   |$0000,x                 ;terminate list
1299 D817 E8                    inx   
1300 D818 E8                    inx   
1301 D819 9E 00 00              stz   |$0000,x
1302 D81C
1303 D81C              ; add the controls to the window
1304 D81C 48                    pha                            ;Result space (not used here)
1305 D81D 48                    pha   
1306 D81E D4 BE                 pei   <init_window+2
1307 D820 D4 BC                 pei   <init_window
1308 D822 F4 03 00              pea   $0003                    ;Ptr to list of Ptrs
1309 D825 F4 01 00              pea   MyControls>>16           ;Ptr to Ptr list
1310 D828 F4 F0 D0              pea   MyControls
1311 D82B A2 10 31              ldx   #$3110                   ;NewControl2
1312 D82E 20 36 D4              jsr   call_tools_0
1313 D831 68                    pla                            ;Discard (not used here)
1314 D832 68                    pla   
1315 D833
1316 D833              ; retrieve the handle of the LineEdit record if it exists
1317 D833              get_handles  
1318 D833 2C 4E D2              bit   pb_flags                 ;editable volume name?
1319 D836 10 30                 bpl   @static_name             ;no...
1320 D838 48                    pha                            ;space for result
1321 D839 48                    pha   
1322 D83A D4 BE                 pei   <init_window+2
1323 D83C D4 BC                 pei   <init_window
1324 D83E F4 00 00              pea   editLineID>>16           ;ID of editLineControl
1325 D841 F4 05 00              pea   editLineID
1326 D844 A2 10 30              ldx   #$3010                   ;GetCtlHandleFromID
1327 D847 20 36 D4              jsr   call_tools_0
1328 D84A 68                    pla                            ;retrieve handle
1329 D84B 85 AA                 sta   init_temp_1
1330 D84D 68                    pla   
1331 D84E 85 AC                 sta   init_temp_1+2
1332 D850
1333 D850 A0 02 00              ldy   #2                       ;deref the control handle
1334 D853 A7 AA                 lda   [init_temp_1]
1335 D855 85 AE                 sta   init_temp_2
1336 D857 B7 AA                 lda   [init_temp_1],y
1337 D859 85 B0                 sta   init_temp_2+2
1338 D85B A0 1C 00              ldy   #octlData                ;offset to LineEdit record handle
1339 D85E B7 AE                 lda   [init_temp_2],y
1340 D860 85 C4                 sta   edit_handle
1341 D862 C8                    iny   
1342 D863 C8                    iny   
1343 D864 B7 AE                 lda   [init_temp_2],y
1344 D866 85 C6                 sta   edit_handle+2
1345 D868              @static_name  
1346 D868              ; retrieve the handle of the default button control (for highlighting purposes)
1347 D868 48                    pha                            ;space for result
1348 D869 48                    pha   
1349 D86A D4 BE                 pei   <init_window+2
1350 D86C D4 BC                 pei   <init_window
1351 D86E F4 00 00              pea   defaultButtonID>>16      ;ID of default button
1352 D871 F4 02 00              pea   defaultButtonID
1353 D874 A2 10 30              ldx   #$3010                   ;GetCtlHandleFromID
1354 D877 20 36 D4              jsr   call_tools_0
1355 D87A 68                    pla                            ;retrieve handle
1356 D87B 85 C0                 sta   ok_handle
1357 D87D 68                    pla   
1358 D87E 85 C2                 sta   ok_handle+2
1359 D880
1360 D880              ; retrieve the handle to the fst list control
1361 D880 48                    pha                            ;space for result
1362 D881 48                    pha   
1363 D882 D4 BE                 pei   <init_window+2           ; where it is
1364 D884 D4 BC                 pei   <init_window
1365 D886 F4 00 00              pea   fstListID>>16            ;ID of fst list control
1366 D889 F4 03 00              pea   fstListID
1367 D88C A2 10 30              ldx   #$3010                   ;GetCtlHandleFromID
1368 D88F 20 36 D4              jsr   call_tools_0
1369 D892 FA                    plx   
1370 D893 86 C8                 stx   <list1_handle
1371 D895 7A                    ply   
1372 D896 84 CA                 sty   <list1_handle+2
1373 D898
1374 D898              ; sort the FST list before we display it
1375 D898 A9 00 00              lda   #$0000
1376 D89B 48                    pha                            ; no custom sort proc
1377 D89C 48                    pha   
1378 D89D 5A                    phy                            ; sort the FST list
1379 D89E DA                    phx                            ; (X and Y still contain the handle)
1380 D89F A2 1C 15              ldx   #$151C                   ; SortList2
1381 D8A2 20 36 D4              jsr   call_tools_0
1382 D8A5
1383 D8A5              ; retrieve the handle to the format options list control
1384 D8A5 48                    pha                            ;space for result
1385 D8A6 48                    pha   
1386 D8A7 D4 BE                 pei   <init_window+2           ; where it is
1387 D8A9 D4 BC                 pei   <init_window
1388 D8AB F4 00 00              pea   intrlvListID>>16         ;ID of options list control
1389 D8AE F4 04 00              pea   intrlvListID
1390 D8B1 A2 10 30              ldx   #$3010                   ;_GetCtlHandleFromID
1391 D8B4 20 36 D4              jsr   call_tools_0
1392 D8B7 68                    pla   
1393 D8B8 85 CC                 sta   <list2_handle
1394 D8BA 68                    pla   
1395 D8BB 85 CE                 sta   <list2_handle+2
1396 D8BD
1397 D8BD              ; set up for initial JudgeName message
1398 D8BD A9 FE FF              lda   #-2
1399 D8C0 8D 1E D0              sta   currentFST               ;init variable
1400 D8C3 18                    clc                            ;no errors
1401 D8C4 60                    rts   
1402 D8C5                       EndP 
1403 D8C5
1404 D8C5                       eject 
1405 D8C5              ;==========================================================
1406 D8C5              ;
1407 D8C5              ;  setup_lists
1408 D8C5              ;
1409 D8C5              ;  Conveniently, my data structures are compatible with
1410 D8C5              ;  those of the list manager.  So really all I do is tell
1411 D8C5              ;  the list mgr where they are, and it sets up the lists
1412 D8C5              ;  for me.
1413 D8C5              ;
1414 D8C5              ;  Inputs:      fst_list_ptr = deref'd & locked addr of list
1415 D8C5              ;               fmt_list_ptr = deref'd & locked addr of list
1416 D8C5              ;               init_window = grafport of the window
1417 D8C5              ;
1418 D8C5              ;  Outputs:     A = trashed
1419 D8C5              ;               X = trashed
1420 D8C5              ;               Y = trashed
1421 D8C5              ;               P = nvmxdizc
1422 D8C5              ;                   ..000..0
1423 D8C5              ;
1424 D8C5              ;  This routine may move memory.
1425 D8C5              ;
1426 D8C5              ;==========================================================
1427 D8C5
1428 D8C5              setup_lists Proc 
1429 D8C5                       Import list1_size,list1_ref
1430 D8C5                       Import list2_size,list2_ref
1431 D8C5                       Import pb_reqFileSysID,pb_flags
1432 D8C5                       Import fst_adj_fmts
1433 D8C5
1434 D8C5                       with my_direct_page,fst_list_record
1435 D8C5
1436 D8C5 64 AC                 stz   <init_temp_1+2           ; init # of selected FST
1437 D8C7
1438 D8C7 AD 4C D2              lda   pb_reqFileSysID          ; valid FST ID supplied?
1439 D8CA D0 0C                 bne   set_default              ; yes, use it as initial selection
1440 D8CC
1441 D8CC              ; At this point, the supplied FST ID is 0.  This means that the caller doesn't
1442 D8CC              ; really care what the initially selected FST is.  So, since the first FST in the
1443 D8CC              ; list is the boot FST, we should make sure that it's the one that is initially
1444 D8CC              ; selected.  (Well, we should supply SOME kinda default, shouldn't we?)
1445 D8CC
1446 D8CC A0 04 00              ldy   #ff_mem_flag             ; get offset of memFlag field
1447 D8CF B7 94                 lda   [<fst_list_ptr],y        ; set it as selected
1448 D8D1 09 80 00              ora   #%10000000
1449 D8D4 97 94                 sta   [<fst_list_ptr],y
1450 D8D6 80 3D                 bra   init_fst_template        ; then go set the pointer in the template
1451 D8D8
1452 D8D8              set_default  
1453 D8D8 64 AA                 stz   init_temp_1              ; start at the beginning of the list
1454 D8DA              @loop     
1455 D8DA A5 AA                 lda   init_temp_1              ; get the member #
1456 D8DC 20 77 D4              jsr   make_fst_ptr             ; go make a pointer
1457 D8DF A0 08 00              ldy   #ff_fs_num               ; get the FST ID from the record
1458 D8E2 B7 98                 lda   [<fst_list_entry],y
1459 D8E4 CD 4C D2              cmp   pb_reqFileSysID          ; do they match?
1460 D8E7 F0 11                 beq   @select_it               ; yes, select it
1461 D8E9 2C 4E D2              bit   pb_flags                 ; only one FST selectable?
1462 D8EC 70 1F                 bvs   @next_one                ; no, leave other FSTs selectable
1463 D8EE A0 04 00              ldy   #ff_mem_flag             ; else dim it
1464 D8F1 B7 98                 lda   [<fst_list_entry],y
1465 D8F3 09 60 00              ora   #%01100000
1466 D8F6 97 98                 sta   [<fst_list_entry],y
1467 D8F8 80 13                 bra   @next_one
1468 D8FA              @select_it  
1469 D8FA A0 04 00              ldy   #ff_mem_flag             ; set the selected bit
1470 D8FD B7 98                 lda   [<fst_list_entry],y
1471 D8FF 89 60 00              bit   #%01100000               ; first, is it selectable?
1472 D902 D0 09                 bne   @next_one                ; no, so don't select it
1473 D904 09 80 00              ora   #%10000000
1474 D907 97 98                 sta   [<fst_list_entry],y
1475 D909 A5 AA                 lda   <init_temp_1             ; remember which FST we've selected
1476 D90B 85 AC                 sta   <init_temp_1+2
1477 D90D              @next_one  
1478 D90D E6 AA                 inc   init_temp_1              ; bump counter
1479 D90F A5 AA                 lda   init_temp_1              ; are we done yet?
1480 D911 C5 9C                 cmp   fst_list_cnt
1481 D913 D0 C5                 bne   @loop                    ; no, go do the next one
1482 D915
1483 D915              init_fst_template  
1484 D915 A5 AC                 lda   <init_temp_1+2           ; make a pointer to the selected FST
1485 D917 20 77 D4              jsr   make_fst_ptr
1486 D91A 22 A4 DB 00           jsl   fst_adj_fmts             ; then initialize the format selections
1487 D91E
1488 D91E              ; fill in the control template for the FST List control
1489 D91E A5 9C                 lda   <fst_list_cnt            ; how many entries
1490 D920 8D 72 D1              sta   |list1_size
1491 D923
1492 D923 A5 94                 lda   <fst_list_ptr            ; where it be
1493 D925 8D 82 D1              sta   |list1_ref
1494 D928 A5 96                 lda   <fst_list_ptr+2
1495 D92A 8D 84 D1              sta   |list1_ref+2
1496 D92D
1497 D92D              ;  Now fill in the template for the format options list control
1498 D92D
1499 D92D A5 8C                 lda   <fmt_disp_cnt            ; how many entries
1500 D92F 8D A0 D1              sta   |list2_size
1501 D932
1502 D932 A5 84                 lda   <fmt_list_ptr            ; where it be
1503 D934 8D B0 D1              sta   |list2_ref
1504 D937 A5 86                 lda   <fmt_list_ptr+2
1505 D939 8D B2 D1              sta   |list2_ref+2
1506 D93C
1507 D93C 18                    clc                            ; no errors
1508 D93D 60                    rts   
1509 D93E                       EndP 
1510 D93E
1511 D93E                       eject 
1512 D93E              ;==========================================================
1513 D93E              ;
1514 D93E              ;  grx_check_name
1515 D93E              ;
1516 D93E              ;  Performs a full JudgeName call with the user-supplied
1517 D93E              ;  volume name prior to exiting the dialog box.
1518 D93E              ;
1519 D93E              ;  Outputs:     P = nvmxdizc
1520 D93E              ;                   ..000..|
1521 D93E              ;                          0=no error, 1=name not acceptable
1522 D93E              ;               path_vp = vp of name if acceptable
1523 D93E              ;
1524 D93E              ;  This routine may move memory.
1525 D93E              ;
1526 D93E              ;  Direct page variable usage is:
1527 D93E              ;
1528 D93E              ;       init_temp_2 = pointer to JudgeName result buffer
1529 D93E              ;       init_temp_3 = handle to LineEdit item
1530 D93E              ;       init_temp_4 = pointer to LineEdit item, or static name
1531 D93E              ;
1532 D93E              ;==========================================================
1533 D93E
1534 D93E              grx_check_name Proc Export
1535 D93E                       Import path_vp,call_judgename,name_default,pb_flags
1536 D93E                       Import call_deref,call_alloc,call_release
1537 D93E                       Import jn_parms:jn_parmBlock
1538 D93E
1539 D93E                       with my_direct_page
1540 D93E                       with jn_parms                  ;gonna use JudgeName parmblock
1541 D93E
1542 D93E              ; first, get some memory to use as a Result Buffer for the JudgeName call
1543 D93E
1544 D93E A9 24 00              lda   #36                      ;GS/OS result buffer
1545 D941 22 00 D4 00           jsl   call_alloc               ;allocate memory for the pathname
1546 D945 8E 20 D0              stx   path_vp                  ;save VP
1547 D948 8C 22 D0              sty   path_vp+2
1548 D94B 22 08 D4 00           jsl   call_deref               ;turn it into a pointer
1549 D94F 86 AE                 stx   init_temp_2              ;save pointer
1550 D951 84 B0                 sty   init_temp_2+2
1551 D953 8A                    txa                            ;save in JudgeName parmblock too
1552 D954 8F 8D B2 00           sta   >jn_parms.name
1553 D958 98                    tya   
1554 D959 8F 8F B2 00           sta   >jn_parms.name+2
1555 D95D
1556 D95D A9 24 00              lda   #36                      ;buffer length
1557 D960 87 AE                 sta   [init_temp_2]            ;store in buffer
1558 D962
1559 D962 2C 4E D2              bit   pb_flags                 ;editable name?
1560 D965 30 18                 bmi   @editable                ;yes...
1561 D967 AD D0 D1              lda   name_default             ;else get pointer to the name
1562 D96A 85 B6                 sta   init_temp_4
1563 D96C AD D2 D1              lda   name_default+2
1564 D96F 85 B8                 sta   init_temp_4+2
1565 D971 A7 B6                 lda   [init_temp_4]            ;get the length
1566 D973 29 FF 00              and   #$00FF                   ;clear high byte
1567 D976 48                    pha                            ;put on stack for later
1568 D977 E6 B6                 inc   init_temp_4              ;adjust pointer to text of name
1569 D979 D0 2E                 bne   fill_result_buffer
1570 D97B E6 B8                 inc   init_temp_4+2
1571 D97D 80 2A                 bra   fill_result_buffer
1572 D97F
1573 D97F              @editable  
1574 D97F 48                    pha                            ;result space
1575 D980 D4 C6                 pei   edit_handle+2            ;handle of editLine record
1576 D982 D4 C4                 pei   edit_handle
1577 D984 A2 14 23              ldx   #$2314                   ;LEGetTextLen
1578 D987 22 00 00 E1           jsl   $E10000
1579 D98B                                                      ;leave length on stack
1580 D98B
1581 D98B 48                    pha                            ;result space
1582 D98C 48                    pha   
1583 D98D D4 C6                 pei   edit_handle+2            ;handle of editLine record
1584 D98F D4 C4                 pei   edit_handle
1585 D991 A2 14 22              ldx   #$2214                   ;LEGetTextHand
1586 D994 22 00 00 E1           jsl   $E10000
1587 D998 68                    pla                            ;retrieve handle
1588 D999 85 B2                 sta   init_temp_3
1589 D99B 68                    pla   
1590 D99C 85 B4                 sta   init_temp_3+2
1591 D99E
1592 D99E A7 B2                 lda   [init_temp_3]            ;deref LineEdit text handle
1593 D9A0 85 B6                 sta   init_temp_4
1594 D9A2 A0 02 00              ldy   #2
1595 D9A5 B7 B2                 lda   [init_temp_3],y
1596 D9A7 85 B8                 sta   init_temp_4+2
1597 D9A9
1598 D9A9              fill_result_buffer  
1599 D9A9 A0 02 00              ldy   #2
1600 D9AC A3 01                 lda   1,s                      ;retrieve LineEdit item length
1601 D9AE C9 21 00              cmp   #33                      ;> 32 characters?
1602 D9B1 90 05                 bcc   @good_length             ;no...
1603 D9B3 A9 20 00              lda   #32                      ;else peg it out at 32
1604 D9B6 83 01                 sta   1,s                      ;update length on stack
1605 D9B8              @good_length  
1606 D9B8 97 AE                 sta   [init_temp_2],y          ;store in buffer
1607 D9BA
1608 D9BA A5 AE                 lda   init_temp_2              ;adjust pointer to result buffer
1609 D9BC 18                    clc   
1610 D9BD 69 04 00              adc   #4                       ;to skip buffer length and string length
1611 D9C0 85 AE                 sta   init_temp_2
1612 D9C2 90 02                 bcc   @1
1613 D9C4 E6 B0                 inc   init_temp_2+2
1614 D9C6              @1        
1615 D9C6 7A                    ply                            ;retrieve length
1616 D9C7 E2 20                 sep   #$20                     ;8-bit accumulator
1617 D9C9                       longa off
1618 D9C9 88                    dey                            ;adjust for first character
1619 D9CA              @loop     
1620 D9CA B7 B6                 lda   [init_temp_4],y
1621 D9CC 97 AE                 sta   [init_temp_2],y
1622 D9CE 88                    dey   
1623 D9CF 10 F9                 bpl   @loop                    ;copy volume name to result buffer
1624 D9D1
1625 D9D1 C2 20                 rep   #$20                     ;16-bit accumulator again
1626 D9D3                       longa on
1627 D9D3 A9 06 00              lda   #6                       ;reset pCount
1628 D9D6 8F 81 B2 00           sta   >jn_parms.pCount
1629 D9DA A9 00 00              lda   #0
1630 D9DD 8F 91 B2 00           sta   >jn_parms.nameFlags      ;clear translation flags
1631 D9E1
1632 D9E1 F4 00 00              pea   call_judgename>>16
1633 D9E4 F4 36 B2              pea   call_judgename
1634 D9E7 F4 00 00              pea   0
1635 D9EA 22 87 B1 00           jsl   >lc_dispatcher           ; call JudgeName to get the prompt pointer
1636 D9EE
1637 D9EE AF 91 B2 00           lda   >jn_parms.nameFlags      ;was the FST happy?
1638 D9F2 29 00 E0              and   #$E000                   ;mask off reserved bits
1639 D9F5 18                    clc                            ;assume it was OK
1640 D9F6 F0 11                 beq   @name_good               ;yes, exit
1641 D9F8
1642 D9F8 AE 20 D0              ldx   path_vp                  ;get the VP to the result buffer
1643 D9FB AC 22 D0              ldy   path_vp+2
1644 D9FE 22 10 D4 00           jsl   call_release             ;release it back to the system
1645 DA02 9C 20 D0              stz   path_vp                  ;null out pointer
1646 DA05 9C 22 D0              stz   path_vp+2
1647 DA08 38                    sec                            ;return error
1648 DA09              @name_good  
1649 DA09 60                    rts   
1650 DA0A
1651 DA0A                       EndP 
1652 DA0A
1653 DA0A                       eject 
1654 DA0A              ;==========================================================
1655 DA0A              ;
1656 DA0A              ;  draw_caution
1657 DA0A              ;
1658 DA0A              ;  Draws the Caution icon and an associated message in the
1659 DA0A              ;  message area on the screen.
1660 DA0A              ;
1661 DA0A              ;  Input:       A = Error.Msg # of message to display
1662 DA0A              ;
1663 DA0A              ;  Outputs:     A = trashed
1664 DA0A              ;               X = trashed
1665 DA0A              ;               Y = trashed
1666 DA0A              ;               P = nvmxdizc
1667 DA0A              ;                   ..000...
1668 DA0A              ;               init_temp_1 = trashed
1669 DA0A              ;
1670 DA0A              ;==========================================================
1671 DA0A
1672 DA0A              draw_caution Proc 
1673 DA0A                       Import first_rect,warn_rect
1674 DA0A                       with my_direct_page
1675 DA0A
1676 DA0A 48                    pha                            ; save message # on stack
1677 DA0B
1678 DA0B F4 01 00              pea   warn_rect>>16            ;clear the message area first
1679 DA0E F4 E0 D0              pea   warn_rect
1680 DA11 A2 04 55              ldx   #$5504                   ;EraseRect
1681 DA14 20 36 D4              jsr   call_tools_0
1682 DA17
1683 DA17 48                    pha                            ; result space
1684 DA18 48                    pha   
1685 DA19 F4 01 80              pea   rIcon                    ; resource type
1686 DA1C F4 FF 07              pea   cautionIcon>>16          ; ID of resource
1687 DA1F A2 02 00              ldx   #<stopIcon               ; assume we're using the stop icon
1688 DA22 A3 09                 lda   9,s                      ; get the message #
1689 DA24 C9 3F 00              cmp   #63                      ; is it the Bad Name message?
1690 DA27 F0 03                 beq   @use_stop_icon           ; yes, use the stop icon
1691 DA29 A2 04 00              ldx   #<cautionIcon            ; else use the caution icon
1692 DA2C              @use_stop_icon  
1693 DA2C DA                    phx                            ; put the icon ID on the stack
1694 DA2D A2 1E 0E              ldx   #$0e1e                   ; LoadResource (actually preloaded)
1695 DA30 20 36 D4              jsr   call_tools_0             ; get the Icon out of Sys.Resources
1696 DA33 68                    pla                            ; retrieve handle
1697 DA34 85 AA                 sta   init_temp_1
1698 DA36 68                    pla   
1699 DA37 85 AC                 sta   init_temp_1+2
1700 DA39 B0 18                 bcs   @skip_icon               ; just in case the icon isn't available
1701 DA3B A0 02 00              ldy   #2                       ; deref handle
1702 DA3E B7 AA                 lda   [init_temp_1],y
1703 DA40 48                    pha                            ; put pointer on stack
1704 DA41 A7 AA                 lda   [init_temp_1]
1705 DA43 48                    pha   
1706 DA44 F4 00 F0              pea   %1111000000000000        ; displayMode
1707 DA47 F4 14 00              pea   20                       ; horizontal position
1708 DA4A F4 57 00              pea   87                       ; vertical position
1709 DA4D A2 12 0B              ldx   #$0b12                   ; DrawIcon
1710 DA50 20 36 D4              jsr   call_tools_0
1711 DA53
1712 DA53              @skip_icon  
1713 DA53 A3 01                 lda   1,s                      ; retrieve message #
1714 DA55 22 50 D2 01           jsl   get_string
1715 DA59 84 AC                 sty   <init_temp_1+2           ; save pointer to string
1716 DA5B 86 AA                 stx   <init_temp_1
1717 DA5D E8                    inx                            ; bump past length byte
1718 DA5E D0 01                 bne   @1
1719 DA60 C8                    iny   
1720 DA61              @1        
1721 DA61 5A                    phy                            ; put pointer on stack
1722 DA62 DA                    phx   
1723 DA63 A7 AA                 lda   [<init_temp_1]           ; get length byte
1724 DA65 29 FF 00              and   #$00FF                   ; clear high byte
1725 DA68 48                    pha                            ; put on stack
1726 DA69 F4 01 00              pea   first_rect>>16
1727 DA6C F4 E8 D0              pea   first_rect
1728 DA6F F4 00 00              pea   0                        ; justification
1729 DA72 A2 14 20              ldx   #$2014                   ; LETextBox2
1730 DA75 20 36 D4              jsr   call_tools_0
1731 DA78
1732 DA78 68                    pla                            ; retrieve message #
1733 DA79 38                    sec                            ; it's either 62 or 63
1734 DA7A E9 40 00              sbc   #64                      ; make either -1 or -2
1735 DA7D 8D 1E D0              sta   currentFST
1736 DA80
1737 DA80 60                    rts   
1738 DA81                       EndP 
1739 DA81
1740 DA81                       eject 
1741 DA81              ;==========================================================
1742 DA81              ;
1743 DA81              ;  fill_msg_box
1744 DA81              ;
1745 DA81              ;  Determines which message to draw in the message box, then
1746 DA81              ;  draw it in.
1747 DA81              ;
1748 DA81              ;  Outputs:     A = trashed
1749 DA81              ;               X = trashed
1750 DA81              ;               Y = trashed
1751 DA81              ;               P = nvmxdizc
1752 DA81              ;                   ..000...
1753 DA81              ;
1754 DA81              ;==========================================================
1755 DA81
1756 DA81              fill_msg_box Proc 
1757 DA81                       Import draw_jn_prompt,pb_flags
1758 DA81
1759 DA81 AD 1E D0              lda   currentFST               ; is the initial warning up?
1760 DA84 30 13                 bmi   draw_first_msg           ; yes, restore it
1761 DA86 D0 03                 bne   @1                       ; no, draw real message
1762 DA88              @clr_warning  
1763 DA88 4C 90 D6              jmp   grx_clr_warn             ; else no current selection, clear box
1764 DA8B
1765 DA8B              @1        
1766 DA8B 2C 4E D2              bit   pb_flags                 ; is the volume name editable?
1767 DA8E 10 F8                 bpl   @clr_warning             ; no, no sense in putting up a prompt
1768 DA90
1769 DA90 20 40 D4              jsr   nextmember_1             ; figure out current selection
1770 DA93 9C 1E D0              stz   currentFST               ; force an update
1771 DA96 4C FC DB              jmp   draw_jn_prompt           ; then go draw the prompt
1772 DA99
1773 DA99              ; draw the initial warning message
1774 DA99              draw_first_msg  
1775 DA99 18                    clc   
1776 DA9A 69 40 00              adc   #64                      ; make either 62 or 63
1777 DA9D 4C 0A DA              jmp   draw_caution             ; draw the caution Icon & message
1778 DAA0                       EndP 
1779 DAA0
1780 DAA0                       eject 
1781 DAA0              ;==========================================================
1782 DAA0              ;
1783 DAA0              ;  draw_window
1784 DAA0              ;
1785 DAA0              ;  Since we don't take updates, I do this manually after
1786 DAA0              ;  the window is open and the stuff is there ready to draw.
1787 DAA0              ;
1788 DAA0              ;  Outputs:     A = trashed
1789 DAA0              ;               X = trashed
1790 DAA0              ;               Y = trashed
1791 DAA0              ;               P = nvmxdizc
1792 DAA0              ;                   ..000...
1793 DAA0              ;
1794 DAA0              ;==========================================================
1795 DAA0
1796 DAA0              draw_window Proc Export
1797 DAA0                       Import name_default,my_dp,pb_flags
1798 DAA0                       with my_direct_page
1799 DAA0
1800 DAA0 8B                    phb                            ; save DBR
1801 DAA1 F4 01 01              pea   $0101                    ; set to our data bank
1802 DAA4 AB                    plb   
1803 DAA5 AB                    plb   
1804 DAA6 0B                    phd                            ; save TaskMaster's direct page
1805 DAA7 AD 04 D0              lda   my_dp                    ; set to my direct page
1806 DAAA 5B                    tcd   
1807 DAAB D4 BA                 pei   save_rts                 ; save this, since we're in the middle
1808 DAAD                                                      ; of a TaskMaster call
1809 DAAD
1810 DAAD              ; draw "Initializing" or "Erasing" as appropriate
1811 DAAD F4 28 00              pea   40                       ; horizontal position
1812 DAB0 F4 0E 00              pea   14                       ; vertical position
1813 DAB3 A2 04 3A              ldx   #$3A04                   ; MoveTo
1814 DAB6 20 36 D4              jsr   call_tools_0
1815 DAB9
1816 DAB9 A2 15 00              ldx   #21                      ; get "Initializing" string for Format call
1817 DABC AD 02 D0              lda   which_call               ; was the call Format or Erase?
1818 DABF F0 03                 beq   its_format2              ; it was Format
1819 DAC1 A2 1D 00              ldx   #29                      ; get top string for Erase call
1820 DAC4 8A           its_format2 txa   
1821 DAC5 22 50 D2 01           jsl   get_string
1822 DAC9 5A                    phy                            ; put string pointer on stack
1823 DACA DA                    phx   
1824 DACB A2 04 A5              ldx   #$A504                   ; DrawString
1825 DACE 20 36 D4              jsr   call_tools_0
1826 DAD1
1827 DAD1              ; draw the device name
1828 DAD1 64 00                 stz   <drvr_dev_num            ; device name is in DIB
1829 DAD3 A9 01 00              lda   #get_dib_ptr
1830 DAD6 85 02                 sta   <drvr_call_num
1831 DAD8 A5 36                 lda   <dev_num
1832 DADA 85 04                 sta   <drvr_buf_ptr
1833 DADC 22 18 D4 00           jsl   call_dispatch
1834 DAE0
1835 DAE0 A5 20                 lda   <drvr_dib_ptr            ; make ptr to string
1836 DAE2 18                    clc   
1837 DAE3 69 0E 00              adc   #$0E
1838 DAE6 AA                    tax                            ; save low word in X
1839 DAE7 A5 22                 lda   <drvr_dib_ptr+2          ; high word too!
1840 DAE9 69 00 00              adc   #0000                    ; propogate any carry
1841 DAEC 48                    pha                            ; put pointer on stack
1842 DAED DA                    phx   
1843 DAEE A2 04 A5              ldx   #$A504                   ; DrawString
1844 DAF1 20 36 D4              jsr   call_tools_0
1845 DAF4
1846 DAF4              ; now the "as " string
1847 DAF4 F4 28 00              pea   40                       ; horizontal position
1848 DAF7 F4 1D 00              pea   29                       ; vertical position
1849 DAFA A2 04 3A              ldx   #$3A04                   ; MoveTo
1850 DAFD 20 36 D4              jsr   call_tools_0
1851 DB00
1852 DB00 A9 16 00              lda   #22                      ; get the "as " string
1853 DB03 22 50 D2 01           jsl   get_string
1854 DB07 5A                    phy                            ; put string pointer on stack
1855 DB08 DA                    phx   
1856 DB09 A2 04 A5              ldx   #$A504                   ; DrawString
1857 DB0C 20 36 D4              jsr   call_tools_0
1858 DB0F
1859 DB0F              ; now the volume name, but only if its static
1860 DB0F 2C 4E D2              bit   pb_flags                 ; editable volume name?
1861 DB12 30 20                 bmi   @its_a_control           ; yes, its an editLine control
1862 DB14 F4 D2 00              pea   '“'                      ; else draw static text
1863 DB17 A2 04 A4              ldx   #$A404                   ; surrounded by quotes
1864 DB1A 20 36 D4              jsr   call_tools_0             ; DrawChar
1865 DB1D
1866 DB1D AD D2 D1              lda   name_default+2           ; pointer to string
1867 DB20 48                    pha   
1868 DB21 AD D0 D1              lda   name_default
1869 DB24 48                    pha   
1870 DB25 A2 04 A5              ldx   #$A504                   ; DrawString
1871 DB28 20 36 D4              jsr   call_tools_0
1872 DB2B
1873 DB2B F4 D3 00              pea   '”'
1874 DB2E A2 04 A4              ldx   #$A404                   ; DrawChar
1875 DB31 20 36 D4              jsr   call_tools_0
1876 DB34
1877 DB34              @its_a_control  
1878 DB34 D4 BE                 pei   <init_window+2
1879 DB36 D4 BC                 pei   <init_window
1880 DB38 A2 10 10              ldx   #$1010                   ; DrawControls
1881 DB3B 20 36 D4              jsr   call_tools_0
1882 DB3E
1883 DB3E              ; fill the message box appropriately
1884 DB3E 20 81 DA              jsr   fill_msg_box
1885 DB41
1886 DB41 68                    pla                            ; restore save_rts
1887 DB42 85 BA                 sta   <save_rts
1888 DB44 2B                    pld                            ; restore direct page
1889 DB45 AB                    plb                            ; restore DBR
1890 DB46 6B                    rtl   
1891 DB47                       EndP 
1892 DB47
1893 DB47                       eject 
1894 DB47              ;==========================================================
1895 DB47              ;
1896 DB47              ;  choose_def_fmt
1897 DB47              ;
1898 DB47              ;  Choose a format entry by the following algorithm:
1899 DB47              ;  (1)  If already one, leave them alone
1900 DB47              ;  (2)  If fmt_def_fmt available, choose it
1901 DB47              ;  (3)  Else choose first enabled fmt
1902 DB47              ;
1903 DB47              ;  Input:       fmt_def_fmt = driver refnum of default entry
1904 DB47              ;
1905 DB47              ;  Outputs:     A = trashed
1906 DB47              ;               X = trashed
1907 DB47              ;               Y = trashed
1908 DB47              ;               P = nvmxdizc
1909 DB47              ;                   ..000...
1910 DB47              ;
1911 DB47              ;==========================================================
1912 DB47
1913 DB47              choose_def_fmt Proc 
1914 DB47                       Import choose_def_fmt2
1915 DB47                       with my_direct_page
1916 DB47
1917 DB47              ; do step 1 of algorithm
1918 DB47
1919 DB47 20 46 D4              jsr   nextmember_2
1920 DB4A
1921 DB4A F0 01                 beq   choose_def_1             ; nothing selected
1922 DB4C
1923 DB4C 60                    rts   
1924 DB4D
1925 DB4D              ; do step 2 of algorithm and then step 3 if necessary
1926 DB4D
1927 DB4D              choose_def_1  
1928 DB4D 22 60 DB 00           jsl   choose_def_fmt2
1929 DB51
1930 DB51              ;  now select this entry
1931 DB51
1932 DB51 E6 AA                 inc   <init_temp_1             ; ListMgr starts counting at 1!
1933 DB53 D4 AA                 pei   <init_temp_1             ; member item number
1934 DB55 D4 CE                 pei   <list2_handle+2          ; control handle of format list
1935 DB57 D4 CC                 pei   <list2_handle
1936 DB59 A2 1C 14              ldx   #$141C                   ; SelectMember2
1937 DB5C 20 36 D4              jsr   call_tools_0
1938 DB5F
1939 DB5F 60                    rts   
1940 DB60                       EndP 
1941 DB60
1942 DB60                       Eject 
1943 DB60              ;==========================================================
1944 DB60              ;
1945 DB60              ;  choose_def_fmt2
1946 DB60              ;
1947 DB60              ;  Choose a format entry by the following algorithm:
1948 DB60              ;  (1)  If fmt_def_fmt available, choose it
1949 DB60              ;  (2)  Else choose first enabled fmt
1950 DB60              ;
1951 DB60              ;  Input:       fmt_def_fmt = driver refnum of default entry
1952 DB60              ;
1953 DB60              ;  Outputs:     A = trashed
1954 DB60              ;               X = trashed
1955 DB60              ;               Y = trashed
1956 DB60              ;               P = nvmxdizc
1957 DB60              ;                   ..000...
1958 DB60              ;               fmt_list_entry -> member record to select
1959 DB60              ;               init_temp_1     = item number of record
1960 DB60              ;
1961 DB60              ;==========================================================
1962 DB60
1963 DB60              choose_def_fmt2 Proc Export
1964 DB60                       with my_direct_page,fmt_list_record
1965 DB60
1966 DB60              ;  First choice:  The driver-specified default format, if available
1967 DB60
1968 DB60 64 AA                 stz   <init_temp_1             ; entry counter
1969 DB62
1970 DB62              choose_def_2  
1971 DB62 A5 AA                 lda   <init_temp_1
1972 DB64 20 59 D4              jsr   make_fmt_ptr
1973 DB67
1974 DB67 A0 0E 00              ldy   #df_conf_num             ; look for specified fmt
1975 DB6A B7 88                 lda   [<fmt_list_entry],y
1976 DB6C C5 9E                 cmp   <fmt_def_fmt
1977 DB6E D0 0D                 bne   choose_def_3
1978 DB70
1979 DB70 A0 04 00              ldy   #df_mem_flag             ; is it available?
1980 DB73 B7 88                 lda   [<fmt_list_entry],y
1981 DB75 29 60 00              and   #%01100000
1982 DB78 18                    clc                            ; assume it is.
1983 DB79 F0 28                 beq   choose_def_7             ; yes!
1984 DB7B D0 08                 bne   choose_def_4             ; no.  no need to look further.
1985 DB7D
1986 DB7D              choose_def_3  
1987 DB7D E6 AA                 inc   <init_temp_1
1988 DB7F A5 AA                 lda   <init_temp_1
1989 DB81 C5 8C                 cmp   <fmt_disp_cnt
1990 DB83 D0 DD                 bne   choose_def_2
1991 DB85
1992 DB85              ;  Second choice:  Whatever's available.
1993 DB85
1994 DB85              choose_def_4  
1995 DB85 64 AA                 stz   <init_temp_1             ; entry counter
1996 DB87
1997 DB87              choose_def_5  
1998 DB87 A5 AA                 lda   <init_temp_1
1999 DB89 20 59 D4              jsr   make_fmt_ptr
2000 DB8C
2001 DB8C A0 04 00              ldy   #df_mem_flag             ; is it available?
2002 DB8F B7 88                 lda   [<fmt_list_entry],y
2003 DB91 29 60 00              and   #%01100000
2004 DB94 18                    clc                            ; assume it is.
2005 DB95 F0 0C                 beq   choose_def_7             ; yes!
2006 DB97
2007 DB97              choose_def_6  
2008 DB97 E6 AA                 inc   <init_temp_1
2009 DB99 A5 AA                 lda   <init_temp_1
2010 DB9B C5 8C                 cmp   <fmt_disp_cnt            ;at the end of the list?
2011 DB9D D0 E8                 bne   choose_def_5             ;no, check some more
2012 DB9F A9 65 00              lda   #invalid_fst_op          ;else no matches
2013 DBA2 38                    sec   
2014 DBA3              choose_def_7  
2015 DBA3 6B                    rtl   
2016 DBA4                       EndP 
2017 DBA4
2018 DBA4                       eject 
2019 DBA4              ;==========================================================
2020 DBA4              ;
2021 DBA4              ;  jsl fst_adj_fmts
2022 DBA4              ;
2023 DBA4              ;  Whichever fst is selected controls the hiliting of the
2024 DBA4              ;  formats.  Given an fst in fst_list_entry, scan through
2025 DBA4              ;  the format options, selectively enabling and disabling
2026 DBA4              ;  them.
2027 DBA4              ;
2028 DBA4              ;  Inputs:      fst_list_entry = selected fst
2029 DBA4              ;
2030 DBA4              ;  Outputs:     A = trashed
2031 DBA4              ;               X = trashed
2032 DBA4              ;               Y = trashed
2033 DBA4              ;               P = nvmxdizc
2034 DBA4              ;                   ..000...
2035 DBA4              ;
2036 DBA4              ;==========================================================
2037 DBA4
2038 DBA4              fst_adj_fmts Proc Export
2039 DBA4                       with my_direct_page,fst_list_record,fmt_list_record
2040 DBA4
2041 DBA4 64 AA                 stz   <init_temp_1             ; count fmt's
2042 DBA6 A0 16 00              ldy   #ff_match_ct             ; get match list size
2043 DBA9 B7 98                 lda   [<fst_list_entry],y
2044 DBAB 0A                    asl   a                        ; double it
2045 DBAC 85 AE                 sta   <init_temp_2             ; cache it
2046 DBAE 64 B0                 stz   <init_temp_2+2           ; (counter*2, start at 0)
2047 DBB0 C8                    iny   
2048 DBB1 C8                    iny                            ; setup match list ptr
2049 DBB2 B7 98                 lda   [<fst_list_entry],y
2050 DBB4 AA                    tax   
2051 DBB5 C8                    iny   
2052 DBB6 C8                    iny   
2053 DBB7 B7 98                 lda   [<fst_list_entry],y
2054 DBB9 A8                    tay   
2055 DBBA 22 38 FC 01           jsl   deref
2056 DBBE 86 B2                 stx   <init_temp_3
2057 DBC0 84 B4                 sty   <init_temp_3+2
2058 DBC2
2059 DBC2              fst_adj_lp  
2060 DBC2 A5 AA                 lda   <init_temp_1
2061 DBC4 20 59 D4              jsr   make_fmt_ptr
2062 DBC7
2063 DBC7 A0 06 00              ldy   #df_refnum
2064 DBCA B7 88                 lda   [<fmt_list_entry],y
2065 DBCC A4 B0                 ldy   <init_temp_2+2
2066 DBCE C4 AE                 cpy   <init_temp_2             ; done w/known fmts?
2067 DBD0 F0 14                 beq   disable_fmt              ; yes.  disable all others.
2068 DBD2 D7 B2                 cmp   [<init_temp_3],y
2069 DBD4 D0 10                 bne   disable_fmt              ; in my list? no, disable.
2070 DBD6
2071 DBD6 A0 04 00              ldy   #df_mem_flag             ; enable it!
2072 DBD9 B7 88                 lda   [<fmt_list_entry],y
2073 DBDB 29 9F FF              and   #~%01100000              ; bits 5 & 6 off
2074 DBDE 97 88                 sta   [<fmt_list_entry],y
2075 DBE0
2076 DBE0 E6 B0                 inc   <init_temp_2+2           ; bump to next known
2077 DBE2 E6 B0                 inc   <init_temp_2+2
2078 DBE4 80 0D                 bra   fst_adj_nx
2079 DBE6
2080 DBE6              disable_fmt  
2081 DBE6 A0 04 00              ldy   #df_mem_flag             ; disable it!
2082 DBE9 B7 88                 lda   [<fmt_list_entry],y
2083 DBEB 29 7F FF              and   #~%10000000              ; bit 7 off
2084 DBEE 09 60 00              ora   #%01100000               ; bit 5 & 6 on
2085 DBF1 97 88                 sta   [<fmt_list_entry],y
2086 DBF3
2087 DBF3              fst_adj_nx  
2088 DBF3 E6 AA                 inc   <init_temp_1             ; move to next fmt
2089 DBF5 A5 AA                 lda   <init_temp_1
2090 DBF7 C5 8C                 cmp   <fmt_disp_cnt
2091 DBF9 D0 C7                 bne   fst_adj_lp
2092 DBFB
2093 DBFB 6B                    rtl   
2094 DBFC                       EndP 
2095 DBFC
2096 DBFC                       eject 
2097 DBFC              ;==========================================================
2098 DBFC              ;
2099 DBFC              ;  draw_jn_prompt
2100 DBFC              ;
2101 DBFC              ;  Determines whether or not to draw the prompt string
2102 DBFC              ;  supplied by the JudgeName call
2103 DBFC              ;
2104 DBFC              ;  Input:       A = ListMgr item # of currently selected member
2105 DBFC              ;
2106 DBFC              ;  Outputs:     A = trashed
2107 DBFC              ;               X = trashed
2108 DBFC              ;               Y = trashed
2109 DBFC              ;               P = nvmxdizc
2110 DBFC              ;                   ..000.x.
2111 DBFC              ;                         0     = currently selected FST changed
2112 DBFC              ;                         1     = no change needed
2113 DBFC              ;
2114 DBFC              ;==========================================================
2115 DBFC
2116 DBFC              draw_jn_prompt Proc 
2117 DBFC                       Import pb_flags
2118 DBFC                       with my_direct_page,fst_list_record
2119 DBFC
2120 DBFC 3A                    dec   a                        ; fix ListMgr's number base
2121 DBFD 20 77 D4              jsr   make_fst_ptr             ; make a pointer to the member record
2122 DC00 A0 08 00              ldy   #ff_fs_num               ; get the selected FST ID
2123 DC03 B7 98                 lda   [<fst_list_entry],y
2124 DC05 CD 1E D0              cmp   currentFST               ; has it changed?
2125 DC08 F0 34                 beq   @no_change               ; no, no need to update the prompt
2126 DC0A
2127 DC0A 8D 1E D0              sta   currentFST               ; reset the variable
2128 DC0D
2129 DC0D 2C 4E D2              bit   pb_flags                 ; is the name editable?
2130 DC10 10 2C                 bpl   @no_change               ; no, so don't draw anything
2131 DC12
2132 DC12 A0 1E 00              ldy   #ff_prompt+2             ; index to prompt pointer
2133 DC15 B7 98                 lda   [<fst_list_entry],y      ; retrieve the pointer
2134 DC17 85 AC                 sta   init_temp_1+2            ; save for use later
2135 DC19 AA                    tax                            ; save here too
2136 DC1A A0 1C 00              ldy   #ff_prompt               ; get low word of pointer
2137 DC1D B7 98                 lda   [<fst_list_entry],y
2138 DC1F 85 AA                 sta   init_temp_1
2139 DC21 1A                    inc   a                        ;bump pointer past length byte
2140 DC22 D0 01                 bne   @1
2141 DC24 E8                    inx   
2142 DC25              @1        
2143 DC25 DA                    phx                            ;put pointer on stack
2144 DC26 48                    pha   
2145 DC27 A7 AA                 lda   [init_temp_1]            ;get length
2146 DC29 29 FF 00              and   #$00FF                   ;clear high byte
2147 DC2C 48                    pha                            ;and onto stack for call
2148 DC2D F4 01 00              pea   warn_rect>>16            ;message rect
2149 DC30 F4 E0 D0              pea   warn_rect
2150 DC33 F4 00 00              pea   0                        ;justification (left justified)
2151 DC36 A2 14 20              ldx   #$2014                   ; LETextBox2
2152 DC39 20 36 D4              jsr   call_tools_0
2153 DC3C C2 02                 rep   #%00000010               ; clear Z flag
2154 DC3E              @no_change  
2155 DC3E 60                    rts   
2156 DC3F                       EndP 
2157 DC3F
2158 DC3F                       eject 
2159 DC3F              ;==========================================================
2160 DC3F              ;
2161 DC3F              ;  edit_handler
2162 DC3F              ;
2163 DC3F              ;  handles a control hit in the EditLine control
2164 DC3F              ;
2165 DC3F              ;  Outputs:     A = trashed
2166 DC3F              ;               X = trashed
2167 DC3F              ;               Y = trashed
2168 DC3F              ;               P = nvmxdizc
2169 DC3F              ;                   ..000...
2170 DC3F              ;
2171 DC3F              ;==========================================================
2172 DC3F
2173 DC3F              edit_handler Proc 
2174 DC3F                       import pb_flags
2175 DC3F                       with my_direct_page
2176 DC3F
2177 DC3F AD 1E D0              lda   currentFST               ;non-JudgeName text displayed?
2178 DC42 10 0D                 bpl   chk_name_len             ;no...
2179 DC44 20 40 D4              jsr   nextmember_1             ;get the current selection
2180 DC47 D0 05                 bne   @2                       ;if none,
2181 DC49 20 90 D6              jsr   grx_clr_warn             ;   clear the message area
2182 DC4C 80 25                 bra   disable_ok               ;then dim the default button
2183 DC4E
2184 DC4E              @2        
2185 DC4E 20 FC DB              jsr   draw_jn_prompt           ;else draw the JudgeName prompt
2186 DC51
2187 DC51              ; examine length of LineEdit text and adjust highlighting on OK button
2188 DC51              ; accordingly
2189 DC51                       entry chk_name_len
2190 DC51              chk_name_len  
2191 DC51 2C 4E D2              bit   pb_flags                 ;is there an editable name?
2192 DC54 10 0E                 bpl   @1                       ;no, don't bother checking the length
2193 DC56
2194 DC56 48                    pha                            ;result space
2195 DC57 D4 C6                 pei   edit_handle+2            ;handle of editLine record
2196 DC59 D4 C4                 pei   edit_handle
2197 DC5B A2 14 23              ldx   #$2314                   ;LEGetTextLen
2198 DC5E 20 36 D4              jsr   call_tools_0
2199 DC61 68                    pla                            ;retrieve length
2200 DC62 F0 0F                 beq   disable_ok               ;if zero, disable default button
2201 DC64              @1        
2202 DC64 20 40 D4              jsr   nextmember_1             ;is there an FST selected?
2203 DC67 F0 0A                 beq   disable_ok               ;no...
2204 DC69 20 46 D4              jsr   nextmember_2             ;is there a format selected?
2205 DC6C F0 05                 beq   disable_ok               ;no...
2206 DC6E                                                      ;else fall through into enable_ok
2207 DC6E
2208 DC6E                       eject 
2209 DC6E              ;==========================================================
2210 DC6E              ;
2211 DC6E              ;  enable_ok
2212 DC6E              ;
2213 DC6E              ;  Make sure the ok button is turned on.
2214 DC6E              ;
2215 DC6E              ;  Outputs:     A = trashed
2216 DC6E              ;               X = trashed
2217 DC6E              ;               Y = trashed
2218 DC6E              ;               P = nvmxdizc
2219 DC6E              ;                   ..000...
2220 DC6E              ;
2221 DC6E              ;==========================================================
2222 DC6E                       Entry enable_ok
2223 DC6E              enable_ok  
2224 DC6E F4 00 00              pea   0                        ; =active
2225 DC71 80 03                 bra   call_highlight
2226 DC73
2227 DC73              ;==========================================================
2228 DC73              ;
2229 DC73              ;  disable_ok
2230 DC73              ;
2231 DC73              ;  (1)  Turn off the OK button
2232 DC73              ;  (2)  Make all formats available if applicable
2233 DC73              ;  (3)  Nothing selected either side
2234 DC73              ;
2235 DC73              ;  Outputs:     A = trashed
2236 DC73              ;               X = trashed
2237 DC73              ;               Y = trashed
2238 DC73              ;               P = nvmxdizc
2239 DC73              ;                   ..000...
2240 DC73              ;
2241 DC73              ;==========================================================
2242 DC73
2243 DC73                       Entry disable_ok
2244 DC73              disable_ok  
2245 DC73 F4 FF 00              pea   255                      ; =inactive
2246 DC76              call_highlight  
2247 DC76 D4 C2                 pei   <ok_handle+2
2248 DC78 D4 C0                 pei   <ok_handle
2249 DC7A A2 10 11              ldx   #$1110                   ; HiliteControl
2250 DC7D 20 36 D4              jsr   call_tools_0
2251 DC80
2252 DC80 60                    rts   
2253 DC81                       EndP 
2254 DC81
2255 DC81                       eject 
2256 DC81              ;==========================================================
2257 DC81              ;
2258 DC81              ;  fst_click
2259 DC81              ;
2260 DC81              ;  User clicked on the FST list control.  If no entry is
2261 DC81              ;  selected, disable the ok button and enable all format
2262 DC81              ;  options.  If an entry is indeed selected, scan through
2263 DC81              ;  the format options, selectively enabling and disabling
2264 DC81              ;  them.  If the currently selected fmt becomes unavailable,
2265 DC81              ;  select the first ok one.
2266 DC81              ;
2267 DC81              ;  Outputs:     A = trashed
2268 DC81              ;               X = trashed
2269 DC81              ;               Y = trashed
2270 DC81              ;               P = nvmxdizc
2271 DC81              ;                   ..000...
2272 DC81              ;
2273 DC81              ;==========================================================
2274 DC81
2275 DC81              fst_click Proc 
2276 DC81                       with my_direct_page
2277 DC81
2278 DC81 20 40 D4              jsr   nextmember_1
2279 DC84
2280 DC84 D0 06                 bne   fst_click_1
2281 DC86 20 90 D6              jsr   grx_clr_warn             ; clear the message box
2282 DC89 4C 73 DC              jmp   disable_ok               ; no selection. OK off.
2283 DC8C
2284 DC8C              ;  Ok.  Now work on the fmt option list.
2285 DC8C
2286 DC8C              fst_click_1  
2287 DC8C 48                    pha                            ; save selection #
2288 DC8D 20 65 D6              jsr   grx_too_big              ; tell user if fst too small
2289 DC90 68                    pla                            ; retrieve selection #
2290 DC91 B0 19                 bcs   @no_change               ; don't draw prompt if TooBig is displayed
2291 DC93 20 FC DB              jsr   draw_jn_prompt           ; fix up the judgename prompt
2292 DC96 F0 14                 beq   @no_change               ; if no selection change...
2293 DC98 22 A4 DB 00           jsl   fst_adj_fmts             ; alter format enable bits
2294 DC9C
2295 DC9C              ;  now redraw the fmt list
2296 DC9C
2297 DC9C F4 00 00              pea   #0                       ; NIL = redraw everybody
2298 DC9F D4 CE                 pei   list2_handle+2           ; in the fmt list
2299 DCA1 D4 CC                 pei   list2_handle
2300 DCA3 A2 1C 11              ldx   #$111C                   ; DrawMember2
2301 DCA6 20 36 D4              jsr   call_tools_0
2302 DCA9
2303 DCA9 20 47 DB              jsr   choose_def_fmt           ; and adjust selection
2304 DCAC              @no_change  
2305 DCAC 4C 51 DC              jmp   chk_name_len             ; adjust highlighting on OK button
2306 DCAF                       EndP 
2307 DCAF
2308 DCAF                       eject 
2309 DCAF              ;==========================================================
2310 DCAF              ;
2311 DCAF              ;  fmt_click
2312 DCAF              ;
2313 DCAF              ;  User clicked on the format options list control.  If
2314 DCAF              ;  no entry is selected, disable the OK button.  If an entry
2315 DCAF              ;  is selected, and an fst is already selected, we're done.
2316 DCAF              ;  If an entry is selected, but no fst is selected, choose
2317 DCAF              ;  the 1st applicable fst, and do fst_click to fix the enable
2318 DCAF              ;  bits of the other format entries.
2319 DCAF              ;
2320 DCAF              ;  Outputs:     A = trashed
2321 DCAF              ;               X = trashed
2322 DCAF              ;               Y = trashed
2323 DCAF              ;               P = nvmxdizc
2324 DCAF              ;                   ..000...
2325 DCAF              ;
2326 DCAF              ;==========================================================
2327 DCAF
2328 DCAF              fmt_click Proc 
2329 DCAF                       with my_direct_page,fmt_list_record
2330 DCAF
2331 DCAF 20 46 D4              jsr   nextmember_2
2332 DCB2
2333 DCB2 D0 03                 bne   fmt_click_1
2334 DCB4 4C 73 DC              jmp   disable_ok               ; no selection. OK off.
2335 DCB7
2336 DCB7              ;  see if an FST is also selected.
2337 DCB7
2338 DCB7              fmt_click_1  
2339 DCB7 3A                    dec   a                        ; WE start counting from 0
2340 DCB8 20 59 D4              jsr   make_fmt_ptr
2341 DCBB 20 40 D4              jsr   nextmember_1
2342 DCBE
2343 DCBE F0 03                 beq   fmt_click_2
2344 DCC0
2345 DCC0 4C 51 DC              jmp   chk_name_len             ; adjust highlighting on OK button
2346 DCC3
2347 DCC3              ;  We must select the first available fst.
2348 DCC3
2349 DCC3              fmt_click_2  
2350 DCC3 A0 08 00              ldy   #df_one_fst              ; get fst #
2351 DCC6 B7 88                 lda   [<fmt_list_entry],y
2352 DCC8 1A                    inc   a
2353 DCC9 48                    pha                            ; item number
2354 DCCA D4 CA                 pei   list1_handle+2
2355 DCCC D4 C8                 pei   list1_handle
2356 DCCE A2 1C 14              ldx   #$141C                   ; SelectMember2
2357 DCD1 20 36 D4              jsr   call_tools_0
2358 DCD4
2359 DCD4 4C 81 DC              jmp   fst_click                ; (rts)
2360 DCD7                       EndP 
2361 DCD7
2362 DCD7                       eject 
2363 DCD7              ;==========================================================
2364 DCD7              ;
2365 DCD7              ;  control_hit
2366 DCD7              ;
2367 DCD7              ;  TaskMaster reported a control hit to us.  Figure out which
2368 DCD7              ;  one it was and act on it.
2369 DCD7              ;
2370 DCD7              ;  Outputs:     A = trashed
2371 DCD7              ;               X = trashed
2372 DCD7              ;               Y = trashed
2373 DCD7              ;               P = nvmxdizc
2374 DCD7              ;                   ..000...
2375 DCD7              ;
2376 DCD7              ;==========================================================
2377 DCD7
2378 DCD7              control_hit Proc 
2379 DCD7                       Import TaskData4
2380 DCD7                       with my_direct_page
2381 DCD7
2382 DCD7              ; examine current FST selection to determine if it's changed since the last
2383 DCD7              ; time through here.  If it has, we have to change the message string
2384 DCD7
2385 DCD7 48                    pha                            ;result space
2386 DCD8 48                    pha   
2387 DCD9 A2 04 1C              ldx   #$1C04                   ;GetPort
2388 DCDC 20 36 D4              jsr   call_tools_0             ;save current port
2389 DCDF
2390 DCDF D4 BE                 pei   <init_window+2           ;set current window
2391 DCE1 D4 BC                 pei   <init_window
2392 DCE3 A2 04 1B              ldx   #$1B04                   ;SetPort
2393 DCE6 20 36 D4              jsr   call_tools_0
2394 DCE9
2395 DCE9 AD 1A D2              lda   TaskData4                ;get control ID
2396 DCEC 0A                    asl   a                        ;turn it into an index
2397 DCED AA                    tax   
2398 DCEE FC F8 DC              jsr   (handlers,x)             ;call the control hit handler
2399 DCF1
2400 DCF1 A2 04 1B              ldx   #$1B04                   ;SetPort
2401 DCF4 20 36 D4              jsr   call_tools_0             ;reset port
2402 DCF7
2403 DCF7 60           ignore   rts                            ;back to event loop
2404 DCF8
2405 DCF8 F7 DC        handlers DC W:ignore                    ;dummy entry (no control ID 0)
2406 DCFA 04 DD                 DC W:cancel_handler            ;Cancel button
2407 DCFC 0A DD                 DC W:default_handler           ;default button handler
2408 DCFE 81 DC                 DC W:fst_click                 ;FST List control
2409 DD00 AF DC                 DC W:fmt_click                 ;format list control
2410 DD02 3F DC                 DC W:edit_handler              ;line edit control
2411 DD04
2412 DD04                       eject 
2413 DD04              ; The Cancel button was pressed.  Exit without doing anything...
2414 DD04              cancel_handler  
2415 DD04 A9 01 00              lda   #1                       ;cancel button pressed
2416 DD07 85 A6                 sta   <init_choice
2417 DD09 60                    rts                            ;back to event loop, will exit
2418 DD0A
2419 DD0A              ; The default (Initialize or Erase) button was pressed.  Must set up the volume
2420 DD0A              ; name currently in the LineEdit control and perform a JudgeName call to the
2421 DD0A              ; currently selected FST.  If the FST is happy, we can complete the dialog.  If
2422 DD0A              ; the volume name is no good, we'll tell the user and stay in the dialog to give
2423 DD0A              ; them a chance to fix the name.
2424 DD0A
2425 DD0A              default_handler  
2426 DD0A                       Import pb_flags
2427 DD0A                       Import jn_parms:jn_parmBlock
2428 DD0A                       with my_direct_page,fst_list_record
2429 DD0A                       with jn_parms                  ;gonna use JudgeName parmblock
2430 DD0A
2431 DD0A 20 40 D4              jsr   nextmember_1             ;get the current selection
2432 DD0D 3A                    dec   a
2433 DD0E 20 77 D4              jsr   make_fst_ptr             ;point to the member record
2434 DD11 A0 08 00              ldy   #ff_fs_num               ;get the FST ID
2435 DD14 B7 98                 lda   [fst_list_entry],y
2436 DD16 8F 83 B2 00           sta   >fileSysID               ;store in parmblock
2437 DD1A
2438 DD1A 20 3E D9              jsr   grx_check_name           ;go do a JudgeName call
2439 DD1D 90 15                 bcc   @name_good               ;checked out OK!
2440 DD1F
2441 DD1F 2C 4E D2              bit   pb_flags                 ;was it an editable name?
2442 DD22 10 10                 bpl   @name_good               ;no, just let the FST generate an error
2443 DD24
2444 DD24 F4 09 00              pea   $0009                    ;"bad input" beep type
2445 DD27 A2 03 38              ldx   #$3803                   ;SysBeep2
2446 DD2A 20 36 D4              jsr   call_tools_0             ;get the user's attention
2447 DD2D
2448 DD2D A9 3F 00              lda   #63                      ;message = "The supplied name is unacceptable..."
2449 DD30 20 0A DA              jsr   draw_caution             ;draw the caution message
2450 DD33 60                    rts                            ;then re-enter the event loop
2451 DD34
2452 DD34              @name_good  
2453 DD34 64 A6                 stz   <init_choice             ;the "ok" button was pressed
2454 DD36 60                    rts                            ;back to event loop, will exit
2455 DD37
2456 DD37                       EndP 
2457 DD37
2458 DD37                       eject 
2459 DD37              ;==========================================================
2460 DD37              ;
2461 DD37              ;  grx_loop
2462 DD37              ;
2463 DD37              ;  Event loop for the graphics window.  Waits for mouse
2464 DD37              ;  clicks or keystrokes.
2465 DD37              ;
2466 DD37              ;  Outputs:     init_choice = 0 if ok pressed, 1 if cancel
2467 DD37              ;               A = trashed
2468 DD37              ;               X = trashed
2469 DD37              ;               Y = trashed
2470 DD37              ;               P = nvmxdizc
2471 DD37              ;                   ..000...
2472 DD37              ;
2473 DD37              ;==========================================================
2474 DD37
2475 DD37              grx_loop Proc 
2476 DD37                       Import TaskRecord,grx_too_big,pb_flags,TaskData4
2477 DD37                       Import draw_window,last_control
2478 DD37                       with my_direct_page
2479 DD37
2480 DD37 64 A6                 stz   <init_choice             ; set to -1
2481 DD39 C6 A6                 dec   <init_choice
2482 DD3B
2483 DD3B              grx_loop_0  
2484 DD3B A5 A6                 lda   <init_choice             ; done yet?
2485 DD3D 10 37                 bpl   done
2486 DD3F
2487 DD3F              no_event  
2488 DD3F A9 00 00              lda   #0
2489 DD42 48                    pha                            ;result space
2490 DD43 48                    pha   
2491 DD44 F4 01 00              pea   TaskRecord>>16           ;pointer to extended task record
2492 DD47 F4 F4 D1              pea   TaskRecord
2493 DD4A F4 00 40              pea   $4000+(draw_window>>16)  ;pointer to update routine
2494 DD4D F4 A0 DA              pea   draw_window              ;bit 30=can draw while GS/OS is busy, 10-Jul-92 DAL
2495 DD50 F4 00 80              pea   $8000                    ;eventHook - auto convert command-.
2496 DD53 48                    pha                            ; to ESC keypress
2497 DD54 48                    pha                            ;BeepProc pointer
2498 DD55 48                    pha                            ;(NULL = use SysBeep2)
2499 DD56 F4 09 00              pea   %0000000000001001        ;flags
2500 DD59 A2 0E 64              ldx   #$640E                   ;DoModalWindow
2501 DD5C 20 36 D4              jsr   call_tools_0
2502 DD5F 68                    pla                            ;retrieve result
2503 DD60 FA                    plx                            ;high word - not used
2504 DD61 AA                    tax                            ;did we have a control hit?
2505 DD62 F0 DB                 beq   no_event                 ;no, just loop
2506 DD64 8D 1A D2              sta   TaskData4                ;store the control ID
2507 DD67
2508 DD67 20 D7 DC              jsr   control_hit              ;handle the control hit
2509 DD6A AD 1A D2              lda   TaskData4                ;get the control ID again
2510 DD6D C9 02 00              cmp   #defaultButtonID         ;was it the Initialize button?
2511 DD70 D0 C9                 bne   grx_loop_0               ;no, just continue normally
2512 DD72 A5 A6                 lda   <init_choice             ;was JudgeName happy?
2513 DD74 30 C9                 bmi   no_event                 ;no, so skip the too big message
2514 DD76              done      
2515 DD76 60                    rts   
2516 DD77                       EndP 
2517 DD77
2518 DD77                       eject 
2519 DD77              ;==========================================================
2520 DD77              ;
2521 DD77              ;  record_grx_sel
2522 DD77              ;
2523 DD77              ;  Convert list selections to chosen_fst and chosen_fmt.
2524 DD77              ;
2525 DD77              ;  Outputs:     chosen_fst = entry # of selected FST
2526 DD77              ;               chosen_fmt = entry # of selected format
2527 DD77              ;               A = trashed
2528 DD77              ;               X = trashed
2529 DD77              ;               Y = trashed
2530 DD77              ;               P = nvmxdizc
2531 DD77              ;                   ..000...
2532 DD77              ;
2533 DD77              ;==========================================================
2534 DD77
2535 DD77              record_grx_sel Proc 
2536 DD77                       import path_vp
2537 DD77                       with my_direct_page,fst_list_record
2538 DD77
2539 DD77 64 A2                 stz   <chosen_fst
2540 DD79 64 A4                 stz   <chosen_fmt
2541 DD7B
2542 DD7B 20 40 D4              jsr   nextmember_1
2543 DD7E F0 0B                 beq   record_grx_1
2544 DD80
2545 DD80 3A                    dec   a                        ;fix ListMgr's item #
2546 DD81 20 77 D4              jsr   make_fst_ptr             ;make pointer to record
2547 DD84 A0 08 00              ldy   #ff_fs_num               ;get the FST ID
2548 DD87 B7 98                 lda   [<fst_list_entry],y
2549 DD89 85 A2                 sta   <chosen_fst
2550 DD8B
2551 DD8B              record_grx_1  
2552 DD8B 20 46 D4              jsr   nextmember_2
2553 DD8E F0 03                 beq   record_grx_2
2554 DD90
2555 DD90 3A                    dec   a                        ;fix ListMgr's item #
2556 DD91 85 A4                 sta   <chosen_fmt
2557 DD93
2558 DD93              record_grx_2  
2559 DD93 AE 20 D0              ldx   path_vp                  ;get VP of pathname
2560 DD96 AC 22 D0              ldy   path_vp+2
2561 DD99 98                    tya                            ;better see if it's valid
2562 DD9A 0D 20 D0              ora   path_vp
2563 DD9D F0 42                 beq   no_path                  ;no pointer to deref!
2564 DD9F 22 08 D4 00           jsl   call_deref
2565 DDA3 86 AA                 stx   init_temp_1              ;save pointer
2566 DDA5 84 AC                 sty   init_temp_1+2
2567 DDA7 8A                    txa                            ;offset by 3 for dest pointer
2568 DDA8 18                    clc                            ;(leave room for leading separator)
2569 DDA9 69 01 00              adc   #1
2570 DDAC 85 AE                 sta   init_temp_2
2571 DDAE 98                    tya   
2572 DDAF 69 00 00              adc   #0
2573 DDB2 85 B0                 sta   init_temp_2+2
2574 DDB4
2575 DDB4 A0 02 00              ldy   #2                       ;get pathname length
2576 DDB7 B7 AA                 lda   [init_temp_1],y
2577 DDB9 1A                    inc   a                        ;bump by 1 for leading separator
2578 DDBA 87 AA                 sta   [init_temp_1]            ;move up over buffer length word
2579 DDBC 18                    clc   
2580 DDBD 69 02 00              adc   #2
2581 DDC0 85 B2                 sta   init_temp_3              ;save as length comparator
2582 DDC2
2583 DDC2 AD 00 D0              lda   which_class              ;make a class 0 or class 1 string?
2584 DDC5 D0 08                 bne   do_copy                  ;class 1, go do it
2585 DDC7 A5 AC                 lda   init_temp_1+2            ;else decrement destination pointer
2586 DDC9 D0 02                 bne   @1
2587 DDCB C6 AC                 dec   init_temp_1+2
2588 DDCD C6 AA        @1       dec   init_temp_1
2589 DDCF
2590 DDCF              do_copy   
2591 DDCF E2 20                 sep   #$20                     ;8-bit accumulator
2592 DDD1                       longa off
2593 DDD1 A9 3A                 lda   #':'                     ;start with a leading separator
2594 DDD3 97 AA                 sta   [init_temp_1],y          ;store in string
2595 DDD5 C8                    iny                            ;y now equals 3
2596 DDD6              @loop     
2597 DDD6 B7 AE                 lda   [init_temp_2],y
2598 DDD8 97 AA                 sta   [init_temp_1],y
2599 DDDA C8                    iny   
2600 DDDB C4 B2                 cpy   init_temp_3
2601 DDDD 90 F7                 bcc   @loop
2602 DDDF C2 20                 rep   #$20                     ;back to 16-bit accumulator
2603 DDE1                       longa on
2604 DDE1              no_path   
2605 DDE1 60                    rts   
2606 DDE2                       EndP 
2607 DDE2
2608 DDE2                       eject 
2609 DDE2              ;==========================================================
2610 DDE2              ;
2611 DDE2              ;  remove_window
2612 DDE2              ;
2613 DDE2              ;  Close the selection window.  This kills the controls too.
2614 DDE2              ;
2615 DDE2              ;  Outputs:     A = trashed
2616 DDE2              ;               X = trashed
2617 DDE2              ;               Y = trashed
2618 DDE2              ;               P = nvmxdizc
2619 DDE2              ;                   ..000...
2620 DDE2              ;
2621 DDE2              ;==========================================================
2622 DDE2
2623 DDE2              remove_window Proc 
2624 DDE2                       with my_direct_page
2625 DDE2
2626 DDE2 D4 BE                 pei   <init_window+2
2627 DDE4 D4 BC                 pei   <init_window
2628 DDE6 A2 0E 0B              ldx   #$0B0E                   ; CloseWindow
2629 DDE9 20 36 D4              jsr   call_tools_0
2630 DDEC
2631 DDEC 60                    rts   
2632 DDED                       EndP 
2633 DDED
2634 DDED                       Eject 
2635 DDED              ;==========================================================
2636 DDED              ;
2637 DDED              ;  grx_dialog
2638 DDED              ;
2639 DDED              ;  Build and actuate the graphics based dialog.  The box
2640 DDED              ;  is an alert window, and it contains the following
2641 DDED              ;  items:
2642 DDED              ;
2643 DDED              ;  String at the top:    Please select a file system and format:
2644 DDED              ;  Left list control:    Available file systems
2645 DDED              ;  Right list control:   Available formats
2646 DDED              ;  Buttons:              Cancel (normal)
2647 DDED              ;                        Ok     (bold)
2648 DDED              ;
2649 DDED              ;  Inputs:      fmt_list_vp = vp of the format options data
2650 DDED              ;               fst_list_vp = vp of the file sys options
2651 DDED              ;
2652 DDED              ;  Outputs:     chosen_fst = selected fst # if init_choice=0
2653 DDED              ;               chosen_fmt = selected fmt # if init_choice=0
2654 DDED              ;               init_choice = 0=OK, 1=Cancel
2655 DDED              ;               A = trashed
2656 DDED              ;               X = trashed
2657 DDED              ;               Y = trashed
2658 DDED              ;               P = nvmxdizc
2659 DDED              ;                   ..000...
2660 DDED              ;
2661 DDED              ;  This routine may move memory.
2662 DDED              ;
2663 DDED              ;==========================================================
2664 DDED
2665 DDED              grx_dialog Proc Export
2666 DDED                       with my_direct_page,fmt_list_record
2667 DDED
2668 DDED 20 0B D7              jsr   set_grx_stack            ; make a bigger one
2669 DDF0
2670 DDF0 22 65 D7 00           jsl   fix_ptrs                 ; at the last moment (locks GIM mem)
2671 DDF4
2672 DDF4 20 C5 D8              jsr   setup_lists              ; create lists
2673 DDF7 20 96 D7              jsr   setup_window             ; create window & controls
2674 DDFA 48                    pha                            ; save old port
2675 DDFB 48                    pha   
2676 DDFC A2 04 1C              ldx   #$1C04                   ; GetPort
2677 DDFF 20 36 D4              jsr   call_tools_0
2678 DE02 D4 BE                 pei   <init_window+2
2679 DE04 D4 BC                 pei   <init_window
2680 DE06 A2 04 1B              ldx   #$1B04                   ; SetPort
2681 DE09 20 36 D4              jsr   call_tools_0
2682 DE0C
2683 DE0C 22 60 DB 00           jsl   choose_def_fmt2          ; find the record of the default format
2684 DE10 A0 04 00              ldy   #df_mem_flag             ; then set the selected bit
2685 DE13 B7 88                 lda   [fmt_list_entry],y
2686 DE15 09 80 00              ora   #%10000000
2687 DE18 97 88                 sta   [fmt_list_entry],y
2688 DE1A 20 AF DC              jsr   fmt_click                ; (after setting fmt, will choose fst)
2689 DE1D 20 3F D7              jsr   fix_cursor               ; reset the cursor to the arrow
2690 DE20
2691 DE20 20 37 DD              jsr   grx_loop                 ; handle clicks & such
2692 DE23 D0 03                 bne   @canceled                ; if init_choice != 0, user canceled
2693 DE25 20 77 DD              jsr   record_grx_sel           ; what did they finally pick?
2694 DE28              @canceled  
2695 DE28 20 56 D7              jsr   restore_cursor           ; set it back to the app's setting
2696 DE2B A2 04 1B              ldx   #$1B04                   ; SetPort (to previous one)
2697 DE2E 20 36 D4              jsr   call_tools_0
2698 DE31 20 E2 DD              jsr   remove_window            ; close the winder
2699 DE34 22 28 D4 00           jsl   call_unlock_mem          ; unlock GIM mem
2700 DE38 20 1C D7              jsr   reset_grx_stack          ; reset to GS/OS stack
2701 DE3B 60                    rts   
2702 DE3C                       EndP 
2703 DE3C
2704 DE3C                       eject 
2705 DE3C              ;==========================================================
2706 DE3C              ;
2707 DE3C              ;  init_present
2708 DE3C              ;
2709 DE3C              ;  Make a presentation to the user.  This is where we
2710 DE3C              ;  split to graphics or text based dialog routines.
2711 DE3C              ;  If the Format or Erase call is class 1 and pcount > 3
2712 DE3C              ;  then the calling program is requesting a specific FST
2713 DE3C              ;  so don't put up a dialog at all.
2714 DE3C              ;
2715 DE3C              ;  Outputs:     A = if c=0, ID of selected fst
2716 DE3C              ;                   if c=1, 0 if cancel selected, error # if error occurred
2717 DE3C              ;               X = trashed
2718 DE3C              ;               Y = trashed
2719 DE3C              ;               P = nvmxdizc
2720 DE3C              ;                   ..000..|
2721 DE3C              ;                          0 = ok to format, 1 = cancel or error
2722 DE3C              ;
2723 DE3C              ;==========================================================
2724 DE3C
2725 DE3C              init_present Proc Export
2726 DE3C                       Import tx_dialog,non_dialog,pb_flags
2727 DE3C                       with my_direct_page
2728 DE3C
2729 DE3C 20 A1 D6              jsr   setup_screen1            ;determine if we are running in text or graphics mode
2730 DE3F
2731 DE3F AD 00 D0              lda   which_class              ;was this a class 1 call?
2732 DE42 F0 10                 beq   do_dialog                ;no - so always put up dialog
2733 DE44 AD 4E D2              lda   pb_flags                 ;yes - so get the flags for the call
2734 DE47 89 FF DF              bit   #%1101111111111111       ;(don't include bit 13 in check)
2735 DE4A D0 08                 bne   do_dialog                ;if non-zero, present dialog
2736 DE4C
2737 DE4C              ; all variables are specified in the call, just do the operation
2738 DE4C
2739 DE4C 22 3D DF 01           jsl   non_dialog
2740 DE50 B0 1B                 bcs   present_cancel           ;error occurred
2741 DE52 80 14                 bra   present_done
2742 DE54
2743 DE54              ; put up a dialog
2744 DE54
2745 DE54              do_dialog  
2746 DE54 A5 A8                 lda   <init_screen
2747 DE56 10 0A                 bpl   present_text
2748 DE58
2749 DE58              ;  use the graphics dialog
2750 DE58
2751 DE58 20 E4 D6              jsr   setup_screen2            ;try to allocate a 1K stack for the graphics routines
2752 DE5B B0 05                 bcs   present_text             ;couldn't get stack so use text mode
2753 DE5D 20 ED DD              jsr   grx_dialog
2754 DE60 80 06                 bra   present_done
2755 DE62
2756 DE62              ;  use the text dialog
2757 DE62
2758 DE62              present_text  
2759 DE62 22 87 DF 01           jsl   tx_dialog
2760 DE66 B0 05                 bcs   present_cancel           ;error occurred
2761 DE68
2762 DE68              ;  now return A & C depending on 'init_choice'
2763 DE68
2764 DE68              present_done  
2765 DE68 A9 00 00              lda   #0
2766 DE6B 46 A6                 lsr   <init_choice             ;set carry if Cancel is selected
2767 DE6D
2768 DE6D              present_cancel  
2769 DE6D 60                    rts   
2770 DE6E                       EndP 
2771 DE6E
2772 DE6E                       eject 
2773 DE6E              ;==========================================================
2774 DE6E              ;
2775 DE6E              ;  init_shutdown
2776 DE6E              ;
2777 DE6E              ;  Init package is done.  We must walk through the structures
2778 DE6E              ;  and release any memory we're using.
2779 DE6E              ;
2780 DE6E              ;  Outputs:     A = trashed
2781 DE6E              ;               X = trashed
2782 DE6E              ;               Y = trashed
2783 DE6E              ;               P = nvmxdizc
2784 DE6E              ;                   ..000...
2785 DE6E              ;
2786 DE6E              ;==========================================================
2787 DE6E
2788 DE6E              init_shutdown Proc Export
2789 DE6E                       with my_direct_page,fmt_list_record,fst_list_record
2790 DE6E
2791 DE6E A5 80                 lda   <fmt_list_vp             ; list exist?
2792 DE70 05 82                 ora   <fmt_list_vp+2
2793 DE72 F0 59                 beq   init_shut_4              ; if no fmt list, no fst list!
2794 DE74
2795 DE74 20 2A D5              jsr   jsl_deref
2796 DE77 64 AA                 stz   <init_temp_1
2797 DE79
2798 DE79              ;  Loop through fmt entries, deleting the strings
2799 DE79
2800 DE79              init_shut_1  
2801 DE79 A5 AA                 lda   <init_temp_1
2802 DE7B 20 59 D4              jsr   make_fmt_ptr
2803 DE7E
2804 DE7E A0 0A 00              ldy   #df_string               ; get the VP
2805 DE81 B7 88                 lda   [<fmt_list_entry],y
2806 DE83 AA                    tax   
2807 DE84 C8                    iny   
2808 DE85 C8                    iny   
2809 DE86 B7 88                 lda   [<fmt_list_entry],y
2810 DE88 A8                    tay   
2811 DE89
2812 DE89 22 10 D4 00           jsl   call_release             ; dropped!
2813 DE8D
2814 DE8D E6 AA                 inc   <init_temp_1             ; next.  done?
2815 DE8F A5 AA                 lda   <init_temp_1
2816 DE91 C5 8C                 cmp   <fmt_disp_cnt
2817 DE93 D0 E4                 bne   init_shut_1
2818 DE95
2819 DE95 A6 80                 ldx   <fmt_list_vp             ; and dump the master list
2820 DE97 A4 82                 ldy   <fmt_list_vp+2
2821 DE99 22 10 D4 00           jsl   call_release
2822 DE9D
2823 DE9D              ;  very similar routine:  release match lists from fsts, then
2824 DE9D              ;  dump the fst list.
2825 DE9D
2826 DE9D A5 90                 lda   <fst_list_vp
2827 DE9F 05 92                 ora   <fst_list_vp+2
2828 DEA1 F0 2A                 beq   init_shut_4
2829 DEA3
2830 DEA3 A5 9C                 lda   <fst_list_cnt            ; any FSTs in the list?
2831 DEA5 F0 1E                 beq   dump_master              ; no, just dump the master VP
2832 DEA7
2833 DEA7 64 AA                 stz   <init_temp_1
2834 DEA9
2835 DEA9              init_shut_3  
2836 DEA9 A5 AA                 lda   <init_temp_1
2837 DEAB 20 77 D4              jsr   make_fst_ptr
2838 DEAE
2839 DEAE A0 18 00              ldy   #ff_match_lst            ; get the VP
2840 DEB1 B7 98                 lda   [<fst_list_entry],y
2841 DEB3 AA                    tax   
2842 DEB4 C8                    iny   
2843 DEB5 C8                    iny   
2844 DEB6 B7 98                 lda   [<fst_list_entry],y
2845 DEB8 A8                    tay   
2846 DEB9
2847 DEB9 22 10 D4 00           jsl   call_release             ; dropped!
2848 DEBD
2849 DEBD E6 AA                 inc   <init_temp_1             ; next.  done?
2850 DEBF A5 AA                 lda   <init_temp_1
2851 DEC1 C5 9C                 cmp   <fst_list_cnt
2852 DEC3 D0 E4                 bne   init_shut_3
2853 DEC5
2854 DEC5              dump_master  
2855 DEC5 A6 90                 ldx   <fst_list_vp             ; and dump the master list
2856 DEC7 A4 92                 ldy   <fst_list_vp+2
2857 DEC9 22 10 D4 00           jsl   call_release
2858 DECD
2859 DECD              init_shut_4  
2860 DECD 60                    rts   
2861 DECE                       EndP 
2862 DECE
2863 DECE                       eject 
2864 DECE              ;==========================================================
2865 DECE              ;
2866 DECE              ;  init_main
2867 DECE              ;
2868 DECE              ;  Called by SCM to pre-process the format call.  Presents
2869 DECE              ;  a selection of format and file system options to the user,
2870 DECE              ;  and based on the choice made, presets the driver and returns
2871 DECE              ;  an FST number, which the SCM then calls.
2872 DECE              ;
2873 DECE              ;  Inputs:      dev_num = requested device
2874 DECE              ;               X = call # x 2
2875 DECE              ;               Y = call class x 2
2876 DECE              ;               path2_ptr = pointer to volume name string
2877 DECE              ;
2878 DECE              ;  Outputs:     A = if c == 0, ID number of selected FST
2879 DECE              ;                   if c != 0, 0 if Cancel selected
2880 DECE              ;                              error # is error condition
2881 DECE              ;               X = trashed
2882 DECE              ;               Y = trashed
2883 DECE              ;               P = nvmxdizc
2884 DECE              ;                   ..000..|
2885 DECE              ;                          0=no error, 1=cancel selected or
2886 DECE              ;                                        init pack failed
2887 DECE              ;
2888 DECE              ;  This routine may move memory.
2889 DECE              ;
2890 DECE              ;==========================================================
2891 DECE
2892 DECE              init_main Proc Export
2893 DECE                       Import display_msg,FST_Scan,query_driver
2894 DECE                       Import msg_flag,path_vp,my_dp,pb_flags,pb_reqFileSysID
2895 DECE                       Import jn_parms:jn_parmBlock
2896 DECE
2897 DECE                       with jn_parms,my_direct_page,fst_list_record
2898 DECE
2899 DECE 8B                    phb                            ; remember gs/os data bank
2900 DECF F4 01 01              pea   $0101                    ; our data is in bank 1
2901 DED2 AB                    plb   
2902 DED3 AB                    plb   
2903 DED4
2904 DED4 7B                    tdc                            ; remember our DP for update routine
2905 DED5 8D 04 D0              sta   my_dp
2906 DED8
2907 DED8 64 80                 stz   <fmt_list_vp
2908 DEDA 64 82                 stz   <fmt_list_vp+2
2909 DEDC 64 90                 stz   <fst_list_vp
2910 DEDE 64 92                 stz   <fst_list_vp+2
2911 DEE0
2912 DEE0 8A                    txa                            ; call # x2, $48 or $4A
2913 DEE1 38                    sec   
2914 DEE2 E9 48 00              sbc   #$0048                   ; now its zero or non-zero
2915 DEE5 8D 02 D0              sta   |which_call
2916 DEE8
2917 DEE8 8C 00 D0              sty   |which_class
2918 DEEB
2919 DEEB 9C 10 D0              stz   |msg_flag                ;initialize flag - added 1/89 CAE
2920 DEEE
2921 DEEE A9 01 00              lda   #1                       ;nameType = 1 (for JudgeName)
2922 DEF1 8F 85 B2 00           sta   >nameType
2923 DEF5
2924 DEF5 9C 4E D2              stz   pb_flags                 ;initialize to 0
2925 DEF8 9C 4C D2              stz   pb_reqFileSysID
2926 DEFB              ;
2927 DEFB              ; the following sets the flags word appropriately, according to the following
2928 DEFB              ; table.  If pCount >= 5, we leave the flags alone, since they were specified by
2929 DEFB              ; the user.  Only the upper four bits of the flags are specified in the table.
2930 DEFB              ; Only the upper 2 bits are actually used.
2931 DEFB              ;
2932 DEFB              ; Class 0
2933 DEFB              ; -------
2934 DEFB              ;  %0100 (since volume name is supplied in a class 0 call)
2935 DEFB              ;
2936 DEFB              ; Class 1       pCount  volName == NULL         volName != NULL
2937 DEFB              ; -------       ------  ----------------        ----------------
2938 DEFB              ;               1       N/A (%1100)             N/A (%1100)
2939 DEFB              ;               2       %1100                   %0100
2940 DEFB              ;               3       %1100                   %0100
2941 DEFB              ;               4       %1000                   %0000 (no dialog)
2942 DEFB              ;
2943 DEFB
2944 DEFB AD 00 D0              lda   |which_class             ;is it a class 1 call?
2945 DEFE F0 1E                 beq   @synthesize              ;no, the flags will by synthesized
2946 DF00
2947 DF00 A7 32                 lda   [<param_blk_ptr]         ;get the pCount
2948 DF02 C9 04 00              cmp   #4                       ;reqFileSysID included?
2949 DF05 90 17                 bcc   @synthesize              ;no, so synthesize flags too
2950 DF07 A0 0C 00              ldy   #$0c                     ;offset of parm
2951 DF0A B7 32                 lda   [<param_blk_ptr],y       ;get the parameter
2952 DF0C 8D 4C D2              sta   pb_reqFileSysID          ;store
2953 DF0F
2954 DF0F A7 32                 lda   [<param_blk_ptr]         ;get the pCount
2955 DF11 C9 05 00              cmp   #5                       ;were the flags included?
2956 DF14 90 08                 bcc   @synthesize              ;no, we will synthesize them
2957 DF16 A0 0E 00              ldy   #$0E                     ;offset of flags parameter
2958 DF19 B7 32                 lda   [<param_blk_ptr],y       ;get the flags
2959 DF1B 8D 4E D2              sta   pb_flags                 ;store the flags value
2960 DF1E              @synthesize  
2961 DF1E              ; now we validate the flag values
2962 DF1E AD 4C D2              lda   pb_reqFileSysID          ;is there a valid reqFileSysID?
2963 DF21 D0 09                 bne   @req_valid               ;yes, leave flags as defined
2964 DF23 AD 4E D2              lda   pb_flags                 ;no, so..
2965 DF26 09 00 40              ora   #$4000                   ;..allow user to select
2966 DF29 8D 4E D2              sta   pb_flags
2967 DF2C              @req_valid  
2968 DF2C A5 3E                 lda   <path2_ptr               ;null name supplied?
2969 DF2E 05 40                 ora   <path2_ptr+2
2970 DF30 D0 09                 bne   @name_valid              ;no, leave flags as is
2971 DF32 AD 4E D2              lda   pb_flags                 ;else allow user to edit the name
2972 DF35 09 00 80              ora   #$8000
2973 DF38 8D 4E D2              sta   pb_flags
2974 DF3B              @name_valid  
2975 DF3B 22 32 D5 E0           jsl   query_driver
2976 DF3F B0 1F                 bcs   exit_24
2977 DF41
2978 DF41 22 EE D6 E0           jsl   fst_scan                 ; build FST list
2979 DF45 B0 19                 bcs   exit_24
2980 DF47
2981 DF47 20 2F D5              jsr   find_matches
2982 DF4A B0 14                 bcs   exit_24
2983 DF4C
2984 DF4C 20 3C DE              jsr   init_present
2985 DF4F B0 0F                 bcs   exit_24
2986 DF51 AD 02 D0              lda   |which_call              ; if $25 ERASE, don't set
2987 DF54 D0 07                 bne   sk_set_fmt               ; the formatting options
2988 DF56 20 37 D6              jsr   set_driver_fmt
2989 DF59 22 1B DE 01           jsl   display_msg              ; Added CAE 12/21/88
2990 DF5D              sk_set_fmt  
2991 DF5D A5 A2                 lda   <chosen_fst              ; return the selected FST
2992 DF5F 18                    clc                            ; no error
2993 DF60              exit_24   
2994 DF60 08                    php                            ; save carry
2995 DF61 48                    pha                            ; save FST value or error code
2996 DF62 20 6E DE              jsr   init_shutdown
2997 DF65 AE 20 D0              ldx   path_vp                  ; return new volume name VP
2998 DF68 AC 22 D0              ldy   path_vp+2                ;   in X and Y
2999 DF6B 68                    pla                            ;   and FST ID in Acc
3000 DF6C 28                    plp   
3001 DF6D AB                    plb   
3002 DF6E 6B                    rtl                            ; back to SCM
3003 DF6F
3004 DF6F                       EndP 
3005 DF6F
3006 DF6F              ;===============================================================================
3007 DF6F              ;
3008 DF6F              ; init.2.e
3009 DF6F              ;
3010 DF6F              ;===============================================================================
3011 DF6F
3012 DF6F
3013 DF6F              init_2_end PROC 
3014 DF6F                       ENDP 
3015 DF6F
3016 DF6F              init_2_dummy PROC org init_2_max, skip  ;generate an error if code is too big
3017 DF6F                       ENDP 
3018 DF6F
3019 DF6F                       END   
